/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6DriveEnum;
import physx.extensions.PxD6JointDrive;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJoint;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxJointLimitCone;
import physx.extensions.PxJointLimitPyramid;
import physx.extensions.PxJointLinearLimit;
import physx.extensions.PxJointLinearLimitPair;

public class PxD6Joint
extends PxJoint {
    public static final int SIZEOF = PxD6Joint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxD6Joint() {
    }

    private static native int __sizeOf();

    public static PxD6Joint wrapPointer(long address) {
        return address != 0L ? new PxD6Joint(address) : null;
    }

    public static PxD6Joint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxD6Joint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxD6Joint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void setMotion(PxD6AxisEnum axis, PxD6MotionEnum type) {
        this.checkNotNull();
        Raw.setMotion(this.address, axis.value, type.value);
    }

    public PxD6MotionEnum getMotion(PxD6AxisEnum axis) {
        this.checkNotNull();
        return PxD6MotionEnum.forValue(Raw.getMotion(this.address, axis.value));
    }

    public float getTwistAngle() {
        this.checkNotNull();
        return Raw.getTwistAngle(this.address);
    }

    public float getSwingYAngle() {
        this.checkNotNull();
        return Raw.getSwingYAngle(this.address);
    }

    public float getSwingZAngle() {
        this.checkNotNull();
        return Raw.getSwingZAngle(this.address);
    }

    public void setDistanceLimit(PxJointLinearLimit limit) {
        this.checkNotNull();
        Raw.setDistanceLimit(this.address, limit.getAddress());
    }

    public void setLinearLimit(PxD6AxisEnum axis, PxJointLinearLimitPair limit) {
        this.checkNotNull();
        Raw.setLinearLimit(this.address, axis.value, limit.getAddress());
    }

    public void setTwistLimit(PxJointAngularLimitPair limit) {
        this.checkNotNull();
        Raw.setTwistLimit(this.address, limit.getAddress());
    }

    public void setSwingLimit(PxJointLimitCone limit) {
        this.checkNotNull();
        Raw.setSwingLimit(this.address, limit.getAddress());
    }

    public void setPyramidSwingLimit(PxJointLimitPyramid limit) {
        this.checkNotNull();
        Raw.setPyramidSwingLimit(this.address, limit.getAddress());
    }

    public void setDrive(PxD6DriveEnum index, PxD6JointDrive drive) {
        this.checkNotNull();
        Raw.setDrive(this.address, index.value, drive.getAddress());
    }

    public PxD6JointDrive getDrive(PxD6DriveEnum index) {
        this.checkNotNull();
        return PxD6JointDrive.wrapPointer(Raw.getDrive(this.address, index.value));
    }

    public void setDrivePosition(PxTransform pose) {
        this.checkNotNull();
        Raw.setDrivePosition(this.address, pose.getAddress());
    }

    public void setDrivePosition(PxTransform pose, boolean autowake) {
        this.checkNotNull();
        Raw.setDrivePosition(this.address, pose.getAddress(), autowake);
    }

    public PxTransform getDrivePosition() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getDrivePosition(this.address));
    }

    public void setDriveVelocity(PxVec3 linear, PxVec3 angular) {
        this.checkNotNull();
        Raw.setDriveVelocity(this.address, linear.getAddress(), angular.getAddress());
    }

    public void getDriveVelocity(PxVec3 linear, PxVec3 angular) {
        this.checkNotNull();
        Raw.getDriveVelocity(this.address, linear.getAddress(), angular.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void setMotion(long var0, int var2, int var3);

        public static native int getMotion(long var0, int var2);

        public static native float getTwistAngle(long var0);

        public static native float getSwingYAngle(long var0);

        public static native float getSwingZAngle(long var0);

        public static native void setDistanceLimit(long var0, long var2);

        public static native void setLinearLimit(long var0, int var2, long var3);

        public static native void setTwistLimit(long var0, long var2);

        public static native void setSwingLimit(long var0, long var2);

        public static native void setPyramidSwingLimit(long var0, long var2);

        public static native void setDrive(long var0, int var2, long var3);

        public static native long getDrive(long var0, int var2);

        public static native void setDrivePosition(long var0, long var2);

        public static native void setDrivePosition(long var0, long var2, boolean var4);

        public static native long getDrivePosition(long var0);

        public static native void setDriveVelocity(long var0, long var2, long var4);

        public static native void getDriveVelocity(long var0, long var2, long var4);
    }
}

