/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxD6JointDriveFlags;
import physx.extensions.PxSpring;

public class PxD6JointDrive
extends PxSpring {
    public static final int SIZEOF = PxD6JointDrive.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxD6JointDrive wrapPointer(long address) {
        return address != 0L ? new PxD6JointDrive(address) : null;
    }

    public static PxD6JointDrive arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxD6JointDrive.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxD6JointDrive(long address) {
        super(address);
    }

    public PxD6JointDrive() {
        this.address = Raw.PxD6JointDrive();
    }

    public PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit) {
        this.address = Raw.PxD6JointDrive(driveStiffness, driveDamping, driveForceLimit);
    }

    public PxD6JointDrive(float driveStiffness, float driveDamping, float driveForceLimit, boolean isAcceleration) {
        this.address = Raw.PxD6JointDrive(driveStiffness, driveDamping, driveForceLimit, isAcceleration);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getForceLimit() {
        this.checkNotNull();
        return Raw.getForceLimit(this.address);
    }

    public void setForceLimit(float value) {
        this.checkNotNull();
        Raw.setForceLimit(this.address, value);
    }

    public PxD6JointDriveFlags getFlags() {
        this.checkNotNull();
        return PxD6JointDriveFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxD6JointDriveFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public static class Raw {
        public static native long PxD6JointDrive();

        public static native long PxD6JointDrive(float var0, float var1, float var2);

        public static native long PxD6JointDrive(float var0, float var1, float var2, boolean var3);

        public static native void destroy(long var0);

        public static native float getForceLimit(long var0);

        public static native void setForceLimit(long var0, float var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);
    }
}

