/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxDistanceJointFlagEnum;
import physx.extensions.PxDistanceJointFlags;
import physx.extensions.PxJoint;

public class PxDistanceJoint
extends PxJoint {
    public static final int SIZEOF = PxDistanceJoint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxDistanceJoint() {
    }

    private static native int __sizeOf();

    public static PxDistanceJoint wrapPointer(long address) {
        return address != 0L ? new PxDistanceJoint(address) : null;
    }

    public static PxDistanceJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxDistanceJoint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxDistanceJoint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getDistance() {
        this.checkNotNull();
        return Raw.getDistance(this.address);
    }

    public void setMinDistance(float distance) {
        this.checkNotNull();
        Raw.setMinDistance(this.address, distance);
    }

    public float getMinDistance() {
        this.checkNotNull();
        return Raw.getMinDistance(this.address);
    }

    public void setMaxDistance(float distance) {
        this.checkNotNull();
        Raw.setMaxDistance(this.address, distance);
    }

    public float getMaxDistance() {
        this.checkNotNull();
        return Raw.getMaxDistance(this.address);
    }

    public void setTolerance(float tolerance) {
        this.checkNotNull();
        Raw.setTolerance(this.address, tolerance);
    }

    public float getTolerance() {
        this.checkNotNull();
        return Raw.getTolerance(this.address);
    }

    public void setStiffness(float stiffness) {
        this.checkNotNull();
        Raw.setStiffness(this.address, stiffness);
    }

    public float getStiffness() {
        this.checkNotNull();
        return Raw.getStiffness(this.address);
    }

    public void setDamping(float damping) {
        this.checkNotNull();
        Raw.setDamping(this.address, damping);
    }

    public float getDamping() {
        this.checkNotNull();
        return Raw.getDamping(this.address);
    }

    public void setDistanceJointFlags(PxDistanceJointFlags flags) {
        this.checkNotNull();
        Raw.setDistanceJointFlags(this.address, flags.getAddress());
    }

    public void setDistanceJointFlag(PxDistanceJointFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setDistanceJointFlag(this.address, flag.value, value);
    }

    public PxDistanceJointFlags getDistanceJointFlags() {
        this.checkNotNull();
        return PxDistanceJointFlags.wrapPointer(Raw.getDistanceJointFlags(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native float getDistance(long var0);

        public static native void setMinDistance(long var0, float var2);

        public static native float getMinDistance(long var0);

        public static native void setMaxDistance(long var0, float var2);

        public static native float getMaxDistance(long var0);

        public static native void setTolerance(long var0, float var2);

        public static native float getTolerance(long var0);

        public static native void setStiffness(long var0, float var2);

        public static native float getStiffness(long var0);

        public static native void setDamping(long var0, float var2);

        public static native float getDamping(long var0);

        public static native void setDistanceJointFlags(long var0, long var2);

        public static native void setDistanceJointFlag(long var0, int var2, boolean var3);

        public static native long getDistanceJointFlags(long var0);
    }
}

