/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxMat33;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;

public class PxMassProperties
extends NativeObject {
    public static final int SIZEOF = PxMassProperties.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxMassProperties wrapPointer(long address) {
        return address != 0L ? new PxMassProperties(address) : null;
    }

    public static PxMassProperties arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxMassProperties.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxMassProperties(long address) {
        super(address);
    }

    public PxMassProperties() {
        this.address = Raw.PxMassProperties();
    }

    public PxMassProperties(float m, PxMat33 inertiaT, PxVec3 com) {
        this.address = Raw.PxMassProperties(m, inertiaT.getAddress(), com.getAddress());
    }

    public PxMassProperties(PxGeometry geometry) {
        this.address = Raw.PxMassProperties(geometry.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxMat33 getInertiaTensor() {
        this.checkNotNull();
        return PxMat33.wrapPointer(Raw.getInertiaTensor(this.address));
    }

    public void setInertiaTensor(PxMat33 value) {
        this.checkNotNull();
        Raw.setInertiaTensor(this.address, value.getAddress());
    }

    public PxVec3 getCenterOfMass() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getCenterOfMass(this.address));
    }

    public void setCenterOfMass(PxVec3 value) {
        this.checkNotNull();
        Raw.setCenterOfMass(this.address, value.getAddress());
    }

    public float getMass() {
        this.checkNotNull();
        return Raw.getMass(this.address);
    }

    public void setMass(float value) {
        this.checkNotNull();
        Raw.setMass(this.address, value);
    }

    public void translate(PxVec3 t) {
        this.checkNotNull();
        Raw.translate(this.address, t.getAddress());
    }

    public static PxVec3 getMassSpaceInertia(PxMat33 inertia, PxQuat massFrame) {
        return PxVec3.wrapPointer(Raw.getMassSpaceInertia(inertia.getAddress(), massFrame.getAddress()));
    }

    public static PxMat33 translateInertia(PxMat33 inertia, float mass, PxVec3 t) {
        return PxMat33.wrapPointer(Raw.translateInertia(inertia.getAddress(), mass, t.getAddress()));
    }

    public static PxMat33 rotateInertia(PxMat33 inertia, PxQuat q) {
        return PxMat33.wrapPointer(Raw.rotateInertia(inertia.getAddress(), q.getAddress()));
    }

    public static PxMat33 scaleInertia(PxMat33 inertia, PxQuat scaleRotation, PxVec3 scale) {
        return PxMat33.wrapPointer(Raw.scaleInertia(inertia.getAddress(), scaleRotation.getAddress(), scale.getAddress()));
    }

    public static PxMassProperties sum(PxMassProperties props, PxTransform transforms, int count) {
        return PxMassProperties.wrapPointer(Raw.sum(props.getAddress(), transforms.getAddress(), count));
    }

    public static class Raw {
        public static native long PxMassProperties();

        public static native long PxMassProperties(float var0, long var1, long var3);

        public static native long PxMassProperties(long var0);

        public static native void destroy(long var0);

        public static native long getInertiaTensor(long var0);

        public static native void setInertiaTensor(long var0, long var2);

        public static native long getCenterOfMass(long var0);

        public static native void setCenterOfMass(long var0, long var2);

        public static native float getMass(long var0);

        public static native void setMass(long var0, float var2);

        public static native void translate(long var0, long var2);

        public static native long getMassSpaceInertia(long var0, long var2);

        public static native long translateInertia(long var0, float var2, long var3);

        public static native long rotateInertia(long var0, long var2);

        public static native long scaleInertia(long var0, long var2, long var4);

        public static native long sum(long var0, long var2, int var4);
    }
}

