/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxJoint;
import physx.extensions.PxJointLinearLimitPair;
import physx.extensions.PxPrismaticJointFlagEnum;
import physx.extensions.PxPrismaticJointFlags;

public class PxPrismaticJoint
extends PxJoint {
    public static final int SIZEOF = PxPrismaticJoint.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxPrismaticJoint() {
    }

    private static native int __sizeOf();

    public static PxPrismaticJoint wrapPointer(long address) {
        return address != 0L ? new PxPrismaticJoint(address) : null;
    }

    public static PxPrismaticJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxPrismaticJoint.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxPrismaticJoint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getPosition() {
        this.checkNotNull();
        return Raw.getPosition(this.address);
    }

    public float getVelocity() {
        this.checkNotNull();
        return Raw.getVelocity(this.address);
    }

    public void setLimit(PxJointLinearLimitPair limit) {
        this.checkNotNull();
        Raw.setLimit(this.address, limit.getAddress());
    }

    public void setPrismaticJointFlags(PxPrismaticJointFlags flags) {
        this.checkNotNull();
        Raw.setPrismaticJointFlags(this.address, flags.getAddress());
    }

    public void setPrismaticJointFlag(PxPrismaticJointFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setPrismaticJointFlag(this.address, flag.value, value);
    }

    public PxPrismaticJointFlags getPrismaticJointFlags() {
        this.checkNotNull();
        return PxPrismaticJointFlags.wrapPointer(Raw.getPrismaticJointFlags(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native float getPosition(long var0);

        public static native float getVelocity(long var0);

        public static native void setLimit(long var0, long var2);

        public static native void setPrismaticJointFlags(long var0, long var2);

        public static native void setPrismaticJointFlag(long var0, int var2, boolean var3);

        public static native long getPrismaticJointFlags(long var0);
    }
}

