/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxCollection;
import physx.common.PxInputData;
import physx.common.PxOutputStream;
import physx.cooking.PxCookingParams;
import physx.extensions.PxSerializationRegistry;
import physx.physics.PxPhysics;

public class PxSerialization
extends NativeObject {
    public static final int SIZEOF = PxSerialization.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxSerialization() {
    }

    private static native int __sizeOf();

    public static PxSerialization wrapPointer(long address) {
        return address != 0L ? new PxSerialization(address) : null;
    }

    public static PxSerialization arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSerialization.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSerialization(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static boolean isSerializable(PxCollection collection, PxSerializationRegistry sr) {
        return Raw.isSerializable(collection.getAddress(), sr.getAddress());
    }

    public static boolean isSerializable(PxCollection collection, PxSerializationRegistry sr, PxCollection externalReferences) {
        return Raw.isSerializable(collection.getAddress(), sr.getAddress(), externalReferences.getAddress());
    }

    public static void complete(PxCollection collection, PxSerializationRegistry sr) {
        Raw.complete(collection.getAddress(), sr.getAddress());
    }

    public static void complete(PxCollection collection, PxSerializationRegistry sr, PxCollection exceptFor) {
        Raw.complete(collection.getAddress(), sr.getAddress(), exceptFor.getAddress());
    }

    public static void complete(PxCollection collection, PxSerializationRegistry sr, PxCollection exceptFor, boolean followJoints) {
        Raw.complete(collection.getAddress(), sr.getAddress(), exceptFor.getAddress(), followJoints);
    }

    public static void createSerialObjectIds(PxCollection collection, long base) {
        Raw.createSerialObjectIds(collection.getAddress(), base);
    }

    public static PxCollection createCollectionFromXml(PxInputData inputData, PxCookingParams params, PxSerializationRegistry sr) {
        return PxCollection.wrapPointer(Raw.createCollectionFromXml(inputData.getAddress(), params.getAddress(), sr.getAddress()));
    }

    public static PxCollection createCollectionFromXml(PxInputData inputData, PxCookingParams params, PxSerializationRegistry sr, PxCollection externalRefs) {
        return PxCollection.wrapPointer(Raw.createCollectionFromXml(inputData.getAddress(), params.getAddress(), sr.getAddress(), externalRefs.getAddress()));
    }

    public static PxCollection createCollectionFromBinary(NativeObject memBlock, PxSerializationRegistry sr) {
        return PxCollection.wrapPointer(Raw.createCollectionFromBinary(memBlock.getAddress(), sr.getAddress()));
    }

    public static PxCollection createCollectionFromBinary(NativeObject memBlock, PxSerializationRegistry sr, PxCollection externalRefs) {
        return PxCollection.wrapPointer(Raw.createCollectionFromBinary(memBlock.getAddress(), sr.getAddress(), externalRefs.getAddress()));
    }

    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr) {
        return Raw.serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress());
    }

    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCookingParams params) {
        return Raw.serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), params.getAddress());
    }

    public static boolean serializeCollectionToXml(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCookingParams params, PxCollection externalRefs) {
        return Raw.serializeCollectionToXml(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), params.getAddress(), externalRefs.getAddress());
    }

    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr) {
        return Raw.serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress());
    }

    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCollection externalRefs) {
        return Raw.serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), externalRefs.getAddress());
    }

    public static boolean serializeCollectionToBinary(PxOutputStream outputStream, PxCollection collection, PxSerializationRegistry sr, PxCollection externalRefs, boolean exportNames) {
        return Raw.serializeCollectionToBinary(outputStream.getAddress(), collection.getAddress(), sr.getAddress(), externalRefs.getAddress(), exportNames);
    }

    public static PxSerializationRegistry createSerializationRegistry(PxPhysics physics) {
        return PxSerializationRegistry.wrapPointer(Raw.createSerializationRegistry(physics.getAddress()));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native boolean isSerializable(long var0, long var2);

        public static native boolean isSerializable(long var0, long var2, long var4);

        public static native void complete(long var0, long var2);

        public static native void complete(long var0, long var2, long var4);

        public static native void complete(long var0, long var2, long var4, boolean var6);

        public static native void createSerialObjectIds(long var0, long var2);

        public static native long createCollectionFromXml(long var0, long var2, long var4);

        public static native long createCollectionFromXml(long var0, long var2, long var4, long var6);

        public static native long createCollectionFromBinary(long var0, long var2);

        public static native long createCollectionFromBinary(long var0, long var2, long var4);

        public static native boolean serializeCollectionToXml(long var0, long var2, long var4);

        public static native boolean serializeCollectionToXml(long var0, long var2, long var4, long var6);

        public static native boolean serializeCollectionToXml(long var0, long var2, long var4, long var6, long var8);

        public static native boolean serializeCollectionToBinary(long var0, long var2, long var4);

        public static native boolean serializeCollectionToBinary(long var0, long var2, long var4, long var6);

        public static native boolean serializeCollectionToBinary(long var0, long var2, long var4, long var6, boolean var8);

        public static native long createSerializationRegistry(long var0);
    }
}

