/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;

public class PxSpring
extends NativeObject {
    public static final int SIZEOF = PxSpring.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxSpring() {
    }

    private static native int __sizeOf();

    public static PxSpring wrapPointer(long address) {
        return address != 0L ? new PxSpring(address) : null;
    }

    public static PxSpring arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSpring.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSpring(long address) {
        super(address);
    }

    public static PxSpring createAt(long address, float stiffness, float damping) {
        Raw.PxSpring_placed(address, stiffness, damping);
        PxSpring createdObj = PxSpring.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxSpring createAt(T allocator, NativeObject.Allocator<T> allocate, float stiffness, float damping) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxSpring_placed(address, stiffness, damping);
        PxSpring createdObj = PxSpring.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxSpring(float stiffness, float damping) {
        this.address = Raw.PxSpring(stiffness, damping);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getStiffness() {
        this.checkNotNull();
        return Raw.getStiffness(this.address);
    }

    public void setStiffness(float value) {
        this.checkNotNull();
        Raw.setStiffness(this.address, value);
    }

    public float getDamping() {
        this.checkNotNull();
        return Raw.getDamping(this.address);
    }

    public void setDamping(float value) {
        this.checkNotNull();
        Raw.setDamping(this.address, value);
    }

    public static class Raw {
        public static native void PxSpring_placed(long var0, float var2, float var3);

        public static native long PxSpring(float var0, float var1);

        public static native void destroy(long var0);

        public static native float getStiffness(long var0);

        public static native void setStiffness(long var0, float var2);

        public static native float getDamping(long var0);

        public static native void setDamping(long var0, float var2);
    }
}

