/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.extensions.Support;

public class SphereSupport
extends Support {
    public static final int SIZEOF = SphereSupport.__sizeOf();
    public static final int ALIGNOF = 8;

    protected SphereSupport() {
    }

    private static native int __sizeOf();

    public static SphereSupport wrapPointer(long address) {
        return address != 0L ? new SphereSupport(address) : null;
    }

    public static SphereSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return SphereSupport.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected SphereSupport(long address) {
        super(address);
    }

    public static SphereSupport createAt(long address, float radius) {
        Raw.SphereSupport_placed(address, radius);
        SphereSupport createdObj = SphereSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> SphereSupport createAt(T allocator, NativeObject.Allocator<T> allocate, float radius) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.SphereSupport_placed(address, radius);
        SphereSupport createdObj = SphereSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public SphereSupport(float radius) {
        this.address = Raw.SphereSupport(radius);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getRadius() {
        this.checkNotNull();
        return Raw.getRadius(this.address);
    }

    public void setRadius(float value) {
        this.checkNotNull();
        Raw.setRadius(this.address, value);
    }

    public static class Raw {
        public static native void SphereSupport_placed(long var0, float var2);

        public static native long SphereSupport(float var0);

        public static native void destroy(long var0);

        public static native float getRadius(long var0);

        public static native void setRadius(long var0, float var2);
    }
}

