/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.geometry.PxGeometry;

public class PxBoxGeometry
extends PxGeometry {
    public static final int SIZEOF = PxBoxGeometry.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxBoxGeometry() {
    }

    private static native int __sizeOf();

    public static PxBoxGeometry wrapPointer(long address) {
        return address != 0L ? new PxBoxGeometry(address) : null;
    }

    public static PxBoxGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBoxGeometry.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBoxGeometry(long address) {
        super(address);
    }

    public static PxBoxGeometry createAt(long address, float hx, float hy, float hz) {
        Raw.PxBoxGeometry_placed(address, hx, hy, hz);
        PxBoxGeometry createdObj = PxBoxGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxBoxGeometry createAt(T allocator, NativeObject.Allocator<T> allocate, float hx, float hy, float hz) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxBoxGeometry_placed(address, hx, hy, hz);
        PxBoxGeometry createdObj = PxBoxGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxBoxGeometry(float hx, float hy, float hz) {
        this.address = Raw.PxBoxGeometry(hx, hy, hz);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getHalfExtents() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getHalfExtents(this.address));
    }

    public void setHalfExtents(PxVec3 value) {
        this.checkNotNull();
        Raw.setHalfExtents(this.address, value.getAddress());
    }

    public static class Raw {
        public static native void PxBoxGeometry_placed(long var0, float var2, float var3, float var4);

        public static native long PxBoxGeometry(float var0, float var1, float var2);

        public static native void destroy(long var0);

        public static native long getHalfExtents(long var0);

        public static native void setHalfExtents(long var0, long var2);
    }
}

