/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxRefCounted;
import physx.common.PxVec3;
import physx.geometry.PxHeightFieldDesc;
import physx.geometry.PxHeightFieldFlags;
import physx.geometry.PxHeightFieldFormatEnum;
import physx.geometry.PxHeightFieldSample;

public class PxHeightField
extends PxRefCounted {
    public static final int SIZEOF = PxHeightField.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxHeightField() {
    }

    private static native int __sizeOf();

    public static PxHeightField wrapPointer(long address) {
        return address != 0L ? new PxHeightField(address) : null;
    }

    public static PxHeightField arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxHeightField.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxHeightField(long address) {
        super(address);
    }

    public int saveCells(NativeObject destBuffer, int destBufferSize) {
        this.checkNotNull();
        return Raw.saveCells(this.address, destBuffer.getAddress(), destBufferSize);
    }

    public boolean modifySamples(int startCol, int startRow, PxHeightFieldDesc subfieldDesc) {
        this.checkNotNull();
        return Raw.modifySamples(this.address, startCol, startRow, subfieldDesc.getAddress());
    }

    public boolean modifySamples(int startCol, int startRow, PxHeightFieldDesc subfieldDesc, boolean shrinkBounds) {
        this.checkNotNull();
        return Raw.modifySamples(this.address, startCol, startRow, subfieldDesc.getAddress(), shrinkBounds);
    }

    public int getNbRows() {
        this.checkNotNull();
        return Raw.getNbRows(this.address);
    }

    public int getNbColumns() {
        this.checkNotNull();
        return Raw.getNbColumns(this.address);
    }

    public PxHeightFieldFormatEnum getFormat() {
        this.checkNotNull();
        return PxHeightFieldFormatEnum.forValue(Raw.getFormat(this.address));
    }

    public int getSampleStride() {
        this.checkNotNull();
        return Raw.getSampleStride(this.address);
    }

    public float getConvexEdgeThreshold() {
        this.checkNotNull();
        return Raw.getConvexEdgeThreshold(this.address);
    }

    public PxHeightFieldFlags getFlags() {
        this.checkNotNull();
        return PxHeightFieldFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public float getHeight(float x, float z) {
        this.checkNotNull();
        return Raw.getHeight(this.address, x, z);
    }

    public short getTriangleMaterialIndex(int triangleIndex) {
        this.checkNotNull();
        return Raw.getTriangleMaterialIndex(this.address, triangleIndex);
    }

    public PxVec3 getTriangleNormal(int triangleIndex) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getTriangleNormal(this.address, triangleIndex));
    }

    public PxHeightFieldSample getSample(int row, int column) {
        this.checkNotNull();
        return PxHeightFieldSample.wrapPointer(Raw.getSample(this.address, row, column));
    }

    public int getTimestamp() {
        this.checkNotNull();
        return Raw.getTimestamp(this.address);
    }

    public static class Raw {
        public static native int saveCells(long var0, long var2, int var4);

        public static native boolean modifySamples(long var0, int var2, int var3, long var4);

        public static native boolean modifySamples(long var0, int var2, int var3, long var4, boolean var6);

        public static native int getNbRows(long var0);

        public static native int getNbColumns(long var0);

        public static native int getFormat(long var0);

        public static native int getSampleStride(long var0);

        public static native float getConvexEdgeThreshold(long var0);

        public static native long getFlags(long var0);

        public static native float getHeight(long var0, float var2, float var3);

        public static native short getTriangleMaterialIndex(long var0, int var2);

        public static native long getTriangleNormal(long var0, int var2);

        public static native long getSample(long var0, int var2, int var3);

        public static native int getTimestamp(long var0);
    }
}

