/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxStridedData;
import physx.geometry.PxHeightFieldFlags;
import physx.geometry.PxHeightFieldFormatEnum;

public class PxHeightFieldDesc
extends NativeObject {
    public static final int SIZEOF = PxHeightFieldDesc.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxHeightFieldDesc wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldDesc(address) : null;
    }

    public static PxHeightFieldDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxHeightFieldDesc.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxHeightFieldDesc(long address) {
        super(address);
    }

    public static PxHeightFieldDesc createAt(long address) {
        Raw.PxHeightFieldDesc_placed(address);
        PxHeightFieldDesc createdObj = PxHeightFieldDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxHeightFieldDesc createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxHeightFieldDesc_placed(address);
        PxHeightFieldDesc createdObj = PxHeightFieldDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxHeightFieldDesc() {
        this.address = Raw.PxHeightFieldDesc();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getNbRows() {
        this.checkNotNull();
        return Raw.getNbRows(this.address);
    }

    public void setNbRows(int value) {
        this.checkNotNull();
        Raw.setNbRows(this.address, value);
    }

    public int getNbColumns() {
        this.checkNotNull();
        return Raw.getNbColumns(this.address);
    }

    public void setNbColumns(int value) {
        this.checkNotNull();
        Raw.setNbColumns(this.address, value);
    }

    public PxHeightFieldFormatEnum getFormat() {
        this.checkNotNull();
        return PxHeightFieldFormatEnum.forValue(Raw.getFormat(this.address));
    }

    public void setFormat(PxHeightFieldFormatEnum value) {
        this.checkNotNull();
        Raw.setFormat(this.address, value.value);
    }

    public PxStridedData getSamples() {
        this.checkNotNull();
        return PxStridedData.wrapPointer(Raw.getSamples(this.address));
    }

    public void setSamples(PxStridedData value) {
        this.checkNotNull();
        Raw.setSamples(this.address, value.getAddress());
    }

    public float getConvexEdgeThreshold() {
        this.checkNotNull();
        return Raw.getConvexEdgeThreshold(this.address);
    }

    public void setConvexEdgeThreshold(float value) {
        this.checkNotNull();
        Raw.setConvexEdgeThreshold(this.address, value);
    }

    public PxHeightFieldFlags getFlags() {
        this.checkNotNull();
        return PxHeightFieldFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxHeightFieldFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxHeightFieldDesc_placed(long var0);

        public static native long PxHeightFieldDesc();

        public static native void destroy(long var0);

        public static native int getNbRows(long var0);

        public static native void setNbRows(long var0, int var2);

        public static native int getNbColumns(long var0);

        public static native void setNbColumns(long var0, int var2);

        public static native int getFormat(long var0);

        public static native void setFormat(long var0, int var2);

        public static native long getSamples(long var0);

        public static native void setSamples(long var0, long var2);

        public static native float getConvexEdgeThreshold(long var0);

        public static native void setConvexEdgeThreshold(long var0, float var2);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native void setToDefault(long var0);

        public static native boolean isValid(long var0);
    }
}

