/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.geometry.PxGeometry;
import physx.geometry.PxHeightField;
import physx.geometry.PxMeshGeometryFlags;

public class PxHeightFieldGeometry
extends PxGeometry {
    public static final int SIZEOF = PxHeightFieldGeometry.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxHeightFieldGeometry wrapPointer(long address) {
        return address != 0L ? new PxHeightFieldGeometry(address) : null;
    }

    public static PxHeightFieldGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxHeightFieldGeometry.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxHeightFieldGeometry(long address) {
        super(address);
    }

    public static PxHeightFieldGeometry createAt(long address) {
        Raw.PxHeightFieldGeometry_placed(address);
        PxHeightFieldGeometry createdObj = PxHeightFieldGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxHeightFieldGeometry createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxHeightFieldGeometry_placed(address);
        PxHeightFieldGeometry createdObj = PxHeightFieldGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxHeightFieldGeometry createAt(long address, PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        Raw.PxHeightFieldGeometry_placed(address, hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
        PxHeightFieldGeometry createdObj = PxHeightFieldGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxHeightFieldGeometry createAt(T allocator, NativeObject.Allocator<T> allocate, PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxHeightFieldGeometry_placed(address, hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
        PxHeightFieldGeometry createdObj = PxHeightFieldGeometry.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxHeightFieldGeometry() {
        this.address = Raw.PxHeightFieldGeometry();
    }

    public PxHeightFieldGeometry(PxHeightField hf, PxMeshGeometryFlags flags, float heightScale, float rowScale, float columnScale) {
        this.address = Raw.PxHeightFieldGeometry(hf.getAddress(), flags.getAddress(), heightScale, rowScale, columnScale);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxHeightField getHeightField() {
        this.checkNotNull();
        return PxHeightField.wrapPointer(Raw.getHeightField(this.address));
    }

    public void setHeightField(PxHeightField value) {
        this.checkNotNull();
        Raw.setHeightField(this.address, value.getAddress());
    }

    public float getHeightScale() {
        this.checkNotNull();
        return Raw.getHeightScale(this.address);
    }

    public void setHeightScale(float value) {
        this.checkNotNull();
        Raw.setHeightScale(this.address, value);
    }

    public float getRowScale() {
        this.checkNotNull();
        return Raw.getRowScale(this.address);
    }

    public void setRowScale(float value) {
        this.checkNotNull();
        Raw.setRowScale(this.address, value);
    }

    public float getColumnScale() {
        this.checkNotNull();
        return Raw.getColumnScale(this.address);
    }

    public void setColumnScale(float value) {
        this.checkNotNull();
        Raw.setColumnScale(this.address, value);
    }

    public PxMeshGeometryFlags getHeightFieldFlags() {
        this.checkNotNull();
        return PxMeshGeometryFlags.wrapPointer(Raw.getHeightFieldFlags(this.address));
    }

    public void setHeightFieldFlags(PxMeshGeometryFlags value) {
        this.checkNotNull();
        Raw.setHeightFieldFlags(this.address, value.getAddress());
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxHeightFieldGeometry_placed(long var0);

        public static native void PxHeightFieldGeometry_placed(long var0, long var2, long var4, float var6, float var7, float var8);

        public static native long PxHeightFieldGeometry();

        public static native long PxHeightFieldGeometry(long var0, long var2, float var4, float var5, float var6);

        public static native void destroy(long var0);

        public static native long getHeightField(long var0);

        public static native void setHeightField(long var0, long var2);

        public static native float getHeightScale(long var0);

        public static native void setHeightScale(long var0, float var2);

        public static native float getRowScale(long var0);

        public static native void setRowScale(long var0, float var2);

        public static native float getColumnScale(long var0);

        public static native void setColumnScale(long var0, float var2);

        public static native long getHeightFieldFlags(long var0);

        public static native void setHeightFieldFlags(long var0, long var2);

        public static native boolean isValid(long var0);
    }
}

