/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxBoundedData;
import physx.geometry.PxSimpleTriangleMesh;
import physx.geometry.PxTetrahedronMeshAnalysisResults;
import physx.geometry.PxTetrahedronMeshDesc;
import physx.geometry.PxTriangleMeshAnalysisResults;
import physx.support.PxArray_PxU32;
import physx.support.PxArray_PxVec3;
import physx.support.PxI32ConstPtr;
import physx.support.PxU32ConstPtr;

public class PxTetMaker
extends NativeObject {
    public static final int SIZEOF = PxTetMaker.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxTetMaker() {
    }

    private static native int __sizeOf();

    public static PxTetMaker wrapPointer(long address) {
        return address != 0L ? new PxTetMaker(address) : null;
    }

    public static PxTetMaker arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTetMaker.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTetMaker(long address) {
        super(address);
    }

    public static boolean createConformingTetrahedronMesh(PxSimpleTriangleMesh triangleMesh, PxArray_PxVec3 outVertices, PxArray_PxU32 outTetIndices, boolean validate, float volumeThreshold) {
        return Raw.createConformingTetrahedronMesh(triangleMesh.getAddress(), outVertices.getAddress(), outTetIndices.getAddress(), validate, volumeThreshold);
    }

    public static boolean createVoxelTetrahedronMesh(PxTetrahedronMeshDesc tetMesh, int numVoxelsAlongLongestBoundingBoxAxis, PxArray_PxVec3 outVertices, PxArray_PxU32 outTetIndices) {
        return Raw.createVoxelTetrahedronMesh(tetMesh.getAddress(), numVoxelsAlongLongestBoundingBoxAxis, outVertices.getAddress(), outTetIndices.getAddress());
    }

    public static boolean createVoxelTetrahedronMeshFromEdgeLength(PxTetrahedronMeshDesc tetMesh, float voxelEdgeLength, PxArray_PxVec3 outVertices, PxArray_PxU32 outTetIndices) {
        return Raw.createVoxelTetrahedronMeshFromEdgeLength(tetMesh.getAddress(), voxelEdgeLength, outVertices.getAddress(), outTetIndices.getAddress());
    }

    public static PxTriangleMeshAnalysisResults validateTriangleMesh(PxSimpleTriangleMesh triangleMesh, float minVolumeThreshold, float minTriangleAngleRadians) {
        return PxTriangleMeshAnalysisResults.wrapPointer(Raw.validateTriangleMesh(triangleMesh.getAddress(), minVolumeThreshold, minTriangleAngleRadians));
    }

    public static PxTetrahedronMeshAnalysisResults validateTetrahedronMesh(PxBoundedData points, PxBoundedData tetrahedra, float minTetVolumeThreshold) {
        return PxTetrahedronMeshAnalysisResults.wrapPointer(Raw.validateTetrahedronMesh(points.getAddress(), tetrahedra.getAddress(), minTetVolumeThreshold));
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress());
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress());
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap, float edgeLengthCostWeight) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress(), edgeLengthCostWeight);
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap, float edgeLengthCostWeight, float flatnessDetectionThreshold) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress(), edgeLengthCostWeight, flatnessDetectionThreshold);
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap, float edgeLengthCostWeight, float flatnessDetectionThreshold, boolean projectSimplifiedPointsOnInputMeshSurface) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress(), edgeLengthCostWeight, flatnessDetectionThreshold, projectSimplifiedPointsOnInputMeshSurface);
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap, float edgeLengthCostWeight, float flatnessDetectionThreshold, boolean projectSimplifiedPointsOnInputMeshSurface, PxArray_PxU32 outputVertexToInputTriangle) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress(), edgeLengthCostWeight, flatnessDetectionThreshold, projectSimplifiedPointsOnInputMeshSurface, outputVertexToInputTriangle.getAddress());
    }

    public static void simplifyTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int targetTriangleCount, float maximalEdgeLength, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap, float edgeLengthCostWeight, float flatnessDetectionThreshold, boolean projectSimplifiedPointsOnInputMeshSurface, PxArray_PxU32 outputVertexToInputTriangle, boolean removeDisconnectedPatches) {
        Raw.simplifyTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), targetTriangleCount, maximalEdgeLength, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress(), edgeLengthCostWeight, flatnessDetectionThreshold, projectSimplifiedPointsOnInputMeshSurface, outputVertexToInputTriangle.getAddress(), removeDisconnectedPatches);
    }

    public static void remeshTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int gridResolution, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices) {
        Raw.remeshTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), gridResolution, outputVertices.getAddress(), outputIndices.getAddress());
    }

    public static void remeshTriangleMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, int gridResolution, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, PxArray_PxU32 vertexMap) {
        Raw.remeshTriangleMesh(inputVertices.getAddress(), inputIndices.getAddress(), gridResolution, outputVertices.getAddress(), outputIndices.getAddress(), vertexMap.getAddress());
    }

    public static void createTreeBasedTetrahedralMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, boolean useTreeNodes, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, float volumeThreshold) {
        Raw.createTreeBasedTetrahedralMesh(inputVertices.getAddress(), inputIndices.getAddress(), useTreeNodes, outputVertices.getAddress(), outputIndices.getAddress(), volumeThreshold);
    }

    public static void createRelaxedVoxelTetrahedralMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, int resolution) {
        Raw.createRelaxedVoxelTetrahedralMesh(inputVertices.getAddress(), inputIndices.getAddress(), outputVertices.getAddress(), outputIndices.getAddress(), resolution);
    }

    public static void createRelaxedVoxelTetrahedralMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, int resolution, int numRelaxationIterations) {
        Raw.createRelaxedVoxelTetrahedralMesh(inputVertices.getAddress(), inputIndices.getAddress(), outputVertices.getAddress(), outputIndices.getAddress(), resolution, numRelaxationIterations);
    }

    public static void createRelaxedVoxelTetrahedralMesh(PxArray_PxVec3 inputVertices, PxArray_PxU32 inputIndices, PxArray_PxVec3 outputVertices, PxArray_PxU32 outputIndices, int resolution, int numRelaxationIterations, float relMinTetVolume) {
        Raw.createRelaxedVoxelTetrahedralMesh(inputVertices.getAddress(), inputIndices.getAddress(), outputVertices.getAddress(), outputIndices.getAddress(), resolution, numRelaxationIterations, relMinTetVolume);
    }

    public static void detectTriangleIslands(PxI32ConstPtr triangles, int numTriangles, PxArray_PxU32 islandIndexPerTriangle) {
        Raw.detectTriangleIslands(triangles.getAddress(), numTriangles, islandIndexPerTriangle.getAddress());
    }

    public static int findLargestIslandId(PxU32ConstPtr islandIndexPerTriangle, int numTriangles) {
        return Raw.findLargestIslandId(islandIndexPerTriangle.getAddress(), numTriangles);
    }

    public static class Raw {
        public static native boolean createConformingTetrahedronMesh(long var0, long var2, long var4, boolean var6, float var7);

        public static native boolean createVoxelTetrahedronMesh(long var0, int var2, long var3, long var5);

        public static native boolean createVoxelTetrahedronMeshFromEdgeLength(long var0, float var2, long var3, long var5);

        public static native long validateTriangleMesh(long var0, float var2, float var3);

        public static native long validateTetrahedronMesh(long var0, long var2, float var4);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10, float var12);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10, float var12, float var13);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10, float var12, float var13, boolean var14);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10, float var12, float var13, boolean var14, long var15);

        public static native void simplifyTriangleMesh(long var0, long var2, int var4, float var5, long var6, long var8, long var10, float var12, float var13, boolean var14, long var15, boolean var17);

        public static native void remeshTriangleMesh(long var0, long var2, int var4, long var5, long var7);

        public static native void remeshTriangleMesh(long var0, long var2, int var4, long var5, long var7, long var9);

        public static native void createTreeBasedTetrahedralMesh(long var0, long var2, boolean var4, long var5, long var7, float var9);

        public static native void createRelaxedVoxelTetrahedralMesh(long var0, long var2, long var4, long var6, int var8);

        public static native void createRelaxedVoxelTetrahedralMesh(long var0, long var2, long var4, long var6, int var8, int var9);

        public static native void createRelaxedVoxelTetrahedralMesh(long var0, long var2, long var4, long var6, int var8, int var9, float var10);

        public static native void detectTriangleIslands(long var0, int var2, long var3);

        public static native int findLargestIslandId(long var0, int var2);
    }
}

