/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxTriangle
extends NativeObject {
    public static final int SIZEOF = PxTriangle.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxTriangle wrapPointer(long address) {
        return address != 0L ? new PxTriangle(address) : null;
    }

    public static PxTriangle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTriangle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTriangle(long address) {
        super(address);
    }

    public PxTriangle() {
        this.address = Raw.PxTriangle();
    }

    public PxTriangle(PxVec3 p0, PxVec3 p1, PxVec3 p2) {
        this.address = Raw.PxTriangle(p0.getAddress(), p1.getAddress(), p2.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void normal(PxVec3 normal) {
        this.checkNotNull();
        Raw.normal(this.address, normal.getAddress());
    }

    public void denormalizedNormal(PxVec3 normal) {
        this.checkNotNull();
        Raw.denormalizedNormal(this.address, normal.getAddress());
    }

    public float area() {
        this.checkNotNull();
        return Raw.area(this.address);
    }

    public PxVec3 pointFromUV(float u, float v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.pointFromUV(this.address, u, v));
    }

    public static class Raw {
        public static native long PxTriangle();

        public static native long PxTriangle(long var0, long var2, long var4);

        public static native void destroy(long var0);

        public static native void normal(long var0, long var2);

        public static native void denormalizedNormal(long var0, long var2);

        public static native float area(long var0);

        public static native long pointFromUV(long var0, float var2, float var3);
    }
}

