/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.common.PxBounds3;
import physx.common.PxRefCounted;
import physx.common.PxVec3;
import physx.geometry.PxTriangleMeshFlags;
import physx.support.PxU32ConstPtr;

public class PxTriangleMesh
extends PxRefCounted {
    public static final int SIZEOF = PxTriangleMesh.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxTriangleMesh() {
    }

    private static native int __sizeOf();

    public static PxTriangleMesh wrapPointer(long address) {
        return address != 0L ? new PxTriangleMesh(address) : null;
    }

    public static PxTriangleMesh arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTriangleMesh.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTriangleMesh(long address) {
        super(address);
    }

    public int getNbVertices() {
        this.checkNotNull();
        return Raw.getNbVertices(this.address);
    }

    public PxVec3 getVertices() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getVertices(this.address));
    }

    public PxVec3 getVerticesForModification() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getVerticesForModification(this.address));
    }

    public PxBounds3 refitBVH() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.refitBVH(this.address));
    }

    public int getNbTriangles() {
        this.checkNotNull();
        return Raw.getNbTriangles(this.address);
    }

    public NativeObject getTriangles() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getTriangles(this.address));
    }

    public PxTriangleMeshFlags getTriangleMeshFlags() {
        this.checkNotNull();
        return PxTriangleMeshFlags.wrapPointer(Raw.getTriangleMeshFlags(this.address));
    }

    public PxU32ConstPtr getTrianglesRemap() {
        this.checkNotNull();
        return PxU32ConstPtr.wrapPointer(Raw.getTrianglesRemap(this.address));
    }

    public short getTriangleMaterialIndex(int triangleIndex) {
        this.checkNotNull();
        return Raw.getTriangleMaterialIndex(this.address, triangleIndex);
    }

    public PxBounds3 getLocalBounds() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getLocalBounds(this.address));
    }

    public static class Raw {
        public static native int getNbVertices(long var0);

        public static native long getVertices(long var0);

        public static native long getVerticesForModification(long var0);

        public static native long refitBVH(long var0);

        public static native int getNbTriangles(long var0);

        public static native long getTriangles(long var0);

        public static native long getTriangleMeshFlags(long var0);

        public static native long getTrianglesRemap(long var0);

        public static native short getTriangleMaterialIndex(long var0, int var2);

        public static native long getLocalBounds(long var0);
    }
}

