/*
 * Decompiled with CFR 0.152.
 */
package physx.geometry;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxMassProperties;
import physx.geometry.PxContactBuffer;
import physx.geometry.PxGeometry;
import physx.physics.PxGeomRaycastHit;
import physx.physics.PxGeomSweepHit;
import physx.physics.PxHitFlags;

public class SimpleCustomGeometryCallbacks
extends NativeObject {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    protected SimpleCustomGeometryCallbacks() {
    }

    private static native int __sizeOf();

    public static SimpleCustomGeometryCallbacks wrapPointer(long address) {
        return address != 0L ? new SimpleCustomGeometryCallbacks(address) : null;
    }

    public static SimpleCustomGeometryCallbacks arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return SimpleCustomGeometryCallbacks.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected SimpleCustomGeometryCallbacks(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getPersistentContactManifold_outBreakingThreshold() {
        this.checkNotNull();
        return Raw.getPersistentContactManifold_outBreakingThreshold(this.address);
    }

    public void setPersistentContactManifold_outBreakingThreshold(float value) {
        this.checkNotNull();
        Raw.setPersistentContactManifold_outBreakingThreshold(this.address, value);
    }

    public PxBounds3 getLocalBoundsImpl(PxGeometry geometry) {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getLocalBoundsImpl(this.address, geometry.getAddress()));
    }

    public boolean generateContactsImpl(PxGeometry geom0, PxGeometry geom1, PxTransform pose0, PxTransform pose1, float contactDistance, float meshContactMargin, float toleranceLength, PxContactBuffer contactBuffer) {
        this.checkNotNull();
        return Raw.generateContactsImpl(this.address, geom0.getAddress(), geom1.getAddress(), pose0.getAddress(), pose1.getAddress(), contactDistance, meshContactMargin, toleranceLength, contactBuffer.getAddress());
    }

    public int raycastImpl(PxVec3 origin, PxVec3 unitDir, PxGeometry geom, PxTransform pose, float maxDist, PxHitFlags hitFlags, int maxHits, PxGeomRaycastHit rayHits, int stride) {
        this.checkNotNull();
        return Raw.raycastImpl(this.address, origin.getAddress(), unitDir.getAddress(), geom.getAddress(), pose.getAddress(), maxDist, hitFlags.getAddress(), maxHits, rayHits.getAddress(), stride);
    }

    public boolean overlapImpl(PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1) {
        this.checkNotNull();
        return Raw.overlapImpl(this.address, geom0.getAddress(), pose0.getAddress(), geom1.getAddress(), pose1.getAddress());
    }

    public boolean sweepImpl(PxVec3 unitDir, float maxDist, PxGeometry geom0, PxTransform pose0, PxGeometry geom1, PxTransform pose1, PxGeomSweepHit sweepHit, PxHitFlags hitFlags, float inflation) {
        this.checkNotNull();
        return Raw.sweepImpl(this.address, unitDir.getAddress(), maxDist, geom0.getAddress(), pose0.getAddress(), geom1.getAddress(), pose1.getAddress(), sweepHit.getAddress(), hitFlags.getAddress(), inflation);
    }

    public void computeMassPropertiesImpl(PxGeometry geometry, PxMassProperties massProperties) {
        this.checkNotNull();
        Raw.computeMassPropertiesImpl(this.address, geometry.getAddress(), massProperties.getAddress());
    }

    public boolean usePersistentContactManifoldImpl(PxGeometry geometry) {
        this.checkNotNull();
        return Raw.usePersistentContactManifoldImpl(this.address, geometry.getAddress());
    }

    static {
        PlatformChecks.requirePlatform(15, "physx.geometry.SimpleCustomGeometryCallbacks");
        SIZEOF = SimpleCustomGeometryCallbacks.__sizeOf();
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native float getPersistentContactManifold_outBreakingThreshold(long var0);

        public static native void setPersistentContactManifold_outBreakingThreshold(long var0, float var2);

        public static native long getLocalBoundsImpl(long var0, long var2);

        public static native boolean generateContactsImpl(long var0, long var2, long var4, long var6, long var8, float var10, float var11, float var12, long var13);

        public static native int raycastImpl(long var0, long var2, long var4, long var6, long var8, float var10, long var11, int var13, long var14, int var16);

        public static native boolean overlapImpl(long var0, long var2, long var4, long var6, long var8);

        public static native boolean sweepImpl(long var0, long var2, float var4, long var5, long var7, long var9, long var11, long var13, long var15, float var17);

        public static native void computeMassPropertiesImpl(long var0, long var2, long var4);

        public static native boolean usePersistentContactManifoldImpl(long var0, long var2);
    }
}

