/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.physics.PxActorFlagEnum;
import physx.physics.PxActorFlags;
import physx.physics.PxActorTypeEnum;
import physx.physics.PxScene;

public class PxActor
extends PxBase {
    public static final int SIZEOF = PxActor.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxActor() {
    }

    private static native int __sizeOf();

    public static PxActor wrapPointer(long address) {
        return address != 0L ? new PxActor(address) : null;
    }

    public static PxActor arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxActor.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxActor(long address) {
        super(address);
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setUserData(this.address, value.getAddress());
    }

    public PxActorTypeEnum getType() {
        this.checkNotNull();
        return PxActorTypeEnum.forValue(Raw.getType(this.address));
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public void setName(String name) {
        this.checkNotNull();
        Raw.setName(this.address, name);
    }

    public String getName() {
        this.checkNotNull();
        return Raw.getName(this.address);
    }

    public PxBounds3 getWorldBounds() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getWorldBounds(this.address));
    }

    public PxBounds3 getWorldBounds(float inflation) {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getWorldBounds(this.address, inflation));
    }

    public void setActorFlag(PxActorFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setActorFlag(this.address, flag.value, value);
    }

    public void setActorFlags(PxActorFlags flags) {
        this.checkNotNull();
        Raw.setActorFlags(this.address, flags.getAddress());
    }

    public PxActorFlags getActorFlags() {
        this.checkNotNull();
        return PxActorFlags.wrapPointer(Raw.getActorFlags(this.address));
    }

    public void setDominanceGroup(byte dominanceGroup) {
        this.checkNotNull();
        Raw.setDominanceGroup(this.address, dominanceGroup);
    }

    public byte getDominanceGroup() {
        this.checkNotNull();
        return Raw.getDominanceGroup(this.address);
    }

    public void setOwnerClient(byte inClient) {
        this.checkNotNull();
        Raw.setOwnerClient(this.address, inClient);
    }

    public byte getOwnerClient() {
        this.checkNotNull();
        return Raw.getOwnerClient(this.address);
    }

    public static class Raw {
        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native int getType(long var0);

        public static native long getScene(long var0);

        public static native void setName(long var0, String var2);

        public static native String getName(long var0);

        public static native long getWorldBounds(long var0);

        public static native long getWorldBounds(long var0, float var2);

        public static native void setActorFlag(long var0, int var2, boolean var3);

        public static native void setActorFlags(long var0, long var2);

        public static native long getActorFlags(long var0);

        public static native void setDominanceGroup(long var0, byte var2);

        public static native byte getDominanceGroup(long var0);

        public static native void setOwnerClient(long var0, byte var2);

        public static native byte getOwnerClient(long var0);
    }
}

