/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxBase;
import physx.geometry.PxBVH;
import physx.physics.PxActor;
import physx.physics.PxArticulationReducedCoordinate;
import physx.physics.PxScene;

public class PxAggregate
extends PxBase {
    public static final int SIZEOF = PxAggregate.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxAggregate() {
    }

    private static native int __sizeOf();

    public static PxAggregate wrapPointer(long address) {
        return address != 0L ? new PxAggregate(address) : null;
    }

    public static PxAggregate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxAggregate.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxAggregate(long address) {
        super(address);
    }

    public boolean addActor(PxActor actor) {
        this.checkNotNull();
        return Raw.addActor(this.address, actor.getAddress());
    }

    public boolean addActor(PxActor actor, PxBVH bvh) {
        this.checkNotNull();
        return Raw.addActor(this.address, actor.getAddress(), bvh.getAddress());
    }

    public boolean removeActor(PxActor actor) {
        this.checkNotNull();
        return Raw.removeActor(this.address, actor.getAddress());
    }

    public boolean addArticulation(PxArticulationReducedCoordinate articulation) {
        this.checkNotNull();
        return Raw.addArticulation(this.address, articulation.getAddress());
    }

    public boolean removeArticulation(PxArticulationReducedCoordinate articulation) {
        this.checkNotNull();
        return Raw.removeArticulation(this.address, articulation.getAddress());
    }

    public int getNbActors() {
        this.checkNotNull();
        return Raw.getNbActors(this.address);
    }

    public int getMaxNbActors() {
        this.checkNotNull();
        return Raw.getMaxNbActors(this.address);
    }

    public int getMaxNbShapes() {
        this.checkNotNull();
        return Raw.getMaxNbShapes(this.address);
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public boolean getSelfCollision() {
        this.checkNotNull();
        return Raw.getSelfCollision(this.address);
    }

    public static class Raw {
        public static native boolean addActor(long var0, long var2);

        public static native boolean addActor(long var0, long var2, long var4);

        public static native boolean removeActor(long var0, long var2);

        public static native boolean addArticulation(long var0, long var2);

        public static native boolean removeArticulation(long var0, long var2);

        public static native int getNbActors(long var0);

        public static native int getMaxNbActors(long var0);

        public static native int getMaxNbShapes(long var0);

        public static native long getScene(long var0);

        public static native boolean getSelfCollision(long var0);
    }
}

