/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxArticulationDriveTypeEnum;

public class PxArticulationDrive
extends NativeObject {
    public static final int SIZEOF = PxArticulationDrive.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxArticulationDrive wrapPointer(long address) {
        return address != 0L ? new PxArticulationDrive(address) : null;
    }

    public static PxArticulationDrive arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArticulationDrive.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArticulationDrive(long address) {
        super(address);
    }

    public static PxArticulationDrive createAt(long address) {
        Raw.PxArticulationDrive_placed(address);
        PxArticulationDrive createdObj = PxArticulationDrive.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArticulationDrive createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArticulationDrive_placed(address);
        PxArticulationDrive createdObj = PxArticulationDrive.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxArticulationDrive createAt(long address, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        Raw.PxArticulationDrive_placed(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = PxArticulationDrive.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArticulationDrive createAt(T allocator, NativeObject.Allocator<T> allocate, float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArticulationDrive_placed(address, stiffness, damping, maxForce, driveType.value);
        PxArticulationDrive createdObj = PxArticulationDrive.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxArticulationDrive() {
        this.address = Raw.PxArticulationDrive();
    }

    public PxArticulationDrive(float stiffness, float damping, float maxForce, PxArticulationDriveTypeEnum driveType) {
        this.address = Raw.PxArticulationDrive(stiffness, damping, maxForce, driveType.value);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getStiffness() {
        this.checkNotNull();
        return Raw.getStiffness(this.address);
    }

    public void setStiffness(float value) {
        this.checkNotNull();
        Raw.setStiffness(this.address, value);
    }

    public float getDamping() {
        this.checkNotNull();
        return Raw.getDamping(this.address);
    }

    public void setDamping(float value) {
        this.checkNotNull();
        Raw.setDamping(this.address, value);
    }

    @Deprecated
    public float getMaxForce() {
        this.checkNotNull();
        return Raw.getMaxForce(this.address);
    }

    @Deprecated
    public void setMaxForce(float value) {
        this.checkNotNull();
        Raw.setMaxForce(this.address, value);
    }

    public PxArticulationDriveTypeEnum getDriveType() {
        this.checkNotNull();
        return PxArticulationDriveTypeEnum.forValue(Raw.getDriveType(this.address));
    }

    public void setDriveType(PxArticulationDriveTypeEnum value) {
        this.checkNotNull();
        Raw.setDriveType(this.address, value.value);
    }

    public static class Raw {
        public static native void PxArticulationDrive_placed(long var0);

        public static native void PxArticulationDrive_placed(long var0, float var2, float var3, float var4, int var5);

        public static native long PxArticulationDrive();

        public static native long PxArticulationDrive(float var0, float var1, float var2, int var3);

        public static native void destroy(long var0);

        public static native float getStiffness(long var0);

        public static native void setStiffness(long var0, float var2);

        public static native float getDamping(long var0);

        public static native void setDamping(long var0, float var2);

        public static native float getMaxForce(long var0);

        public static native void setMaxForce(long var0, float var2);

        public static native int getDriveType(long var0);

        public static native void setDriveType(long var0, int var2);
    }
}

