/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxBase;
import physx.common.PxBounds3;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxAggregate;
import physx.physics.PxArticulationCache;
import physx.physics.PxArticulationCacheFlags;
import physx.physics.PxArticulationFixedTendon;
import physx.physics.PxArticulationFlagEnum;
import physx.physics.PxArticulationFlags;
import physx.physics.PxArticulationKinematicFlags;
import physx.physics.PxArticulationLink;
import physx.physics.PxArticulationSpatialTendon;
import physx.physics.PxConstraint;
import physx.physics.PxScene;
import physx.physics.PxSpatialVelocity;

public class PxArticulationReducedCoordinate
extends PxBase {
    public static final int SIZEOF = PxArticulationReducedCoordinate.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxArticulationReducedCoordinate() {
    }

    private static native int __sizeOf();

    public static PxArticulationReducedCoordinate wrapPointer(long address) {
        return address != 0L ? new PxArticulationReducedCoordinate(address) : null;
    }

    public static PxArticulationReducedCoordinate arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArticulationReducedCoordinate.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArticulationReducedCoordinate(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public void setSolverIterationCounts(int minPositionIters) {
        this.checkNotNull();
        Raw.setSolverIterationCounts(this.address, minPositionIters);
    }

    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        this.checkNotNull();
        Raw.setSolverIterationCounts(this.address, minPositionIters, minVelocityIters);
    }

    public boolean isSleeping() {
        this.checkNotNull();
        return Raw.isSleeping(this.address);
    }

    public void setSleepThreshold(float threshold) {
        this.checkNotNull();
        Raw.setSleepThreshold(this.address, threshold);
    }

    public float getSleepThreshold() {
        this.checkNotNull();
        return Raw.getSleepThreshold(this.address);
    }

    public void setStabilizationThreshold(float threshold) {
        this.checkNotNull();
        Raw.setStabilizationThreshold(this.address, threshold);
    }

    public float getStabilizationThreshold() {
        this.checkNotNull();
        return Raw.getStabilizationThreshold(this.address);
    }

    public void setWakeCounter(float wakeCounterValue) {
        this.checkNotNull();
        Raw.setWakeCounter(this.address, wakeCounterValue);
    }

    public float getWakeCounter() {
        this.checkNotNull();
        return Raw.getWakeCounter(this.address);
    }

    public void wakeUp() {
        this.checkNotNull();
        Raw.wakeUp(this.address);
    }

    public void putToSleep() {
        this.checkNotNull();
        Raw.putToSleep(this.address);
    }

    public PxArticulationLink createLink(PxArticulationLink parent, PxTransform pose) {
        this.checkNotNull();
        return PxArticulationLink.wrapPointer(Raw.createLink(this.address, parent != null ? parent.getAddress() : 0L, pose.getAddress()));
    }

    public int getNbLinks() {
        this.checkNotNull();
        return Raw.getNbLinks(this.address);
    }

    public int getNbShapes() {
        this.checkNotNull();
        return Raw.getNbShapes(this.address);
    }

    public void setName(String name) {
        this.checkNotNull();
        Raw.setName(this.address, name);
    }

    public String getName() {
        this.checkNotNull();
        return Raw.getName(this.address);
    }

    public PxBounds3 getWorldBounds() {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getWorldBounds(this.address));
    }

    public PxBounds3 getWorldBounds(float inflation) {
        this.checkNotNull();
        return PxBounds3.wrapPointer(Raw.getWorldBounds(this.address, inflation));
    }

    public PxAggregate getAggregate() {
        this.checkNotNull();
        return PxAggregate.wrapPointer(Raw.getAggregate(this.address));
    }

    public void setArticulationFlags(PxArticulationFlags flags) {
        this.checkNotNull();
        Raw.setArticulationFlags(this.address, flags.getAddress());
    }

    public void setArticulationFlag(PxArticulationFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setArticulationFlag(this.address, flag.value, value);
    }

    public PxArticulationFlags getArticulationFlags() {
        this.checkNotNull();
        return PxArticulationFlags.wrapPointer(Raw.getArticulationFlags(this.address));
    }

    public int getDofs() {
        this.checkNotNull();
        return Raw.getDofs(this.address);
    }

    public PxArticulationCache createCache() {
        this.checkNotNull();
        return PxArticulationCache.wrapPointer(Raw.createCache(this.address));
    }

    public int getCacheDataSize() {
        this.checkNotNull();
        return Raw.getCacheDataSize(this.address);
    }

    public void zeroCache(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.zeroCache(this.address, cache.getAddress());
    }

    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flags) {
        this.checkNotNull();
        Raw.applyCache(this.address, cache.getAddress(), flags.getAddress());
    }

    public void applyCache(PxArticulationCache cache, PxArticulationCacheFlags flags, boolean autowake) {
        this.checkNotNull();
        Raw.applyCache(this.address, cache.getAddress(), flags.getAddress(), autowake);
    }

    public void copyInternalStateToCache(PxArticulationCache cache, PxArticulationCacheFlags flags) {
        this.checkNotNull();
        Raw.copyInternalStateToCache(this.address, cache.getAddress(), flags.getAddress());
    }

    public void commonInit() {
        this.checkNotNull();
        Raw.commonInit(this.address);
    }

    @Deprecated
    public void computeGeneralizedGravityForce(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeGeneralizedGravityForce(this.address, cache.getAddress());
    }

    public void computeGravityCompensation(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeGravityCompensation(this.address, cache.getAddress());
    }

    @Deprecated
    public void computeCoriolisAndCentrifugalForce(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeCoriolisAndCentrifugalForce(this.address, cache.getAddress());
    }

    public void computeCoriolisCompensation(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeCoriolisCompensation(this.address, cache.getAddress());
    }

    public void computeGeneralizedExternalForce(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeGeneralizedExternalForce(this.address, cache.getAddress());
    }

    public void computeJointAcceleration(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeJointAcceleration(this.address, cache.getAddress());
    }

    public void computeJointForce(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeJointForce(this.address, cache.getAddress());
    }

    @Deprecated
    public void computeCoefficientMatrix(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeCoefficientMatrix(this.address, cache.getAddress());
    }

    @Deprecated
    public void computeGeneralizedMassMatrix(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeGeneralizedMassMatrix(this.address, cache.getAddress());
    }

    public void computeMassMatrix(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeMassMatrix(this.address, cache.getAddress());
    }

    public PxVec3 computeArticulationCOM(boolean rootFrame) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.computeArticulationCOM(this.address, rootFrame));
    }

    public void computeCentroidalMomentumMatrix(PxArticulationCache cache) {
        this.checkNotNull();
        Raw.computeCentroidalMomentumMatrix(this.address, cache.getAddress());
    }

    @Deprecated
    public void addLoopJoint(PxConstraint joint) {
        this.checkNotNull();
        Raw.addLoopJoint(this.address, joint.getAddress());
    }

    @Deprecated
    public void removeLoopJoint(PxConstraint joint) {
        this.checkNotNull();
        Raw.removeLoopJoint(this.address, joint.getAddress());
    }

    @Deprecated
    public int getNbLoopJoints() {
        this.checkNotNull();
        return Raw.getNbLoopJoints(this.address);
    }

    @Deprecated
    public int getCoefficientMatrixSize() {
        this.checkNotNull();
        return Raw.getCoefficientMatrixSize(this.address);
    }

    public void setRootGlobalPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setRootGlobalPose(this.address, pose.getAddress());
    }

    public void setRootGlobalPose(PxTransform pose, boolean autowake) {
        this.checkNotNull();
        Raw.setRootGlobalPose(this.address, pose.getAddress(), autowake);
    }

    public PxTransform getRootGlobalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getRootGlobalPose(this.address));
    }

    public void setRootLinearVelocity(PxVec3 linearVelocity) {
        this.checkNotNull();
        Raw.setRootLinearVelocity(this.address, linearVelocity.getAddress());
    }

    public void setRootLinearVelocity(PxVec3 linearVelocity, boolean autowake) {
        this.checkNotNull();
        Raw.setRootLinearVelocity(this.address, linearVelocity.getAddress(), autowake);
    }

    public PxVec3 getRootLinearVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getRootLinearVelocity(this.address));
    }

    public void setRootAngularVelocity(PxVec3 angularVelocity) {
        this.checkNotNull();
        Raw.setRootAngularVelocity(this.address, angularVelocity.getAddress());
    }

    public void setRootAngularVelocity(PxVec3 angularVelocity, boolean autowake) {
        this.checkNotNull();
        Raw.setRootAngularVelocity(this.address, angularVelocity.getAddress(), autowake);
    }

    public PxVec3 getRootAngularVelocity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getRootAngularVelocity(this.address));
    }

    public PxSpatialVelocity getLinkAcceleration(int linkId) {
        this.checkNotNull();
        return PxSpatialVelocity.wrapPointer(Raw.getLinkAcceleration(this.address, linkId));
    }

    public int getGPUIndex() {
        this.checkNotNull();
        return Raw.getGPUIndex(this.address);
    }

    public PxArticulationSpatialTendon createSpatialTendon() {
        this.checkNotNull();
        return PxArticulationSpatialTendon.wrapPointer(Raw.createSpatialTendon(this.address));
    }

    public PxArticulationFixedTendon createFixedTendon() {
        this.checkNotNull();
        return PxArticulationFixedTendon.wrapPointer(Raw.createFixedTendon(this.address));
    }

    public int getNbSpatialTendons() {
        this.checkNotNull();
        return Raw.getNbSpatialTendons(this.address);
    }

    public int getNbFixedTendons() {
        this.checkNotNull();
        return Raw.getNbFixedTendons(this.address);
    }

    public void updateKinematic(PxArticulationKinematicFlags flags) {
        this.checkNotNull();
        Raw.updateKinematic(this.address, flags.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getScene(long var0);

        public static native void setSolverIterationCounts(long var0, int var2);

        public static native void setSolverIterationCounts(long var0, int var2, int var3);

        public static native boolean isSleeping(long var0);

        public static native void setSleepThreshold(long var0, float var2);

        public static native float getSleepThreshold(long var0);

        public static native void setStabilizationThreshold(long var0, float var2);

        public static native float getStabilizationThreshold(long var0);

        public static native void setWakeCounter(long var0, float var2);

        public static native float getWakeCounter(long var0);

        public static native void wakeUp(long var0);

        public static native void putToSleep(long var0);

        public static native long createLink(long var0, long var2, long var4);

        public static native int getNbLinks(long var0);

        public static native int getNbShapes(long var0);

        public static native void setName(long var0, String var2);

        public static native String getName(long var0);

        public static native long getWorldBounds(long var0);

        public static native long getWorldBounds(long var0, float var2);

        public static native long getAggregate(long var0);

        public static native void setArticulationFlags(long var0, long var2);

        public static native void setArticulationFlag(long var0, int var2, boolean var3);

        public static native long getArticulationFlags(long var0);

        public static native int getDofs(long var0);

        public static native long createCache(long var0);

        public static native int getCacheDataSize(long var0);

        public static native void zeroCache(long var0, long var2);

        public static native void applyCache(long var0, long var2, long var4);

        public static native void applyCache(long var0, long var2, long var4, boolean var6);

        public static native void copyInternalStateToCache(long var0, long var2, long var4);

        public static native void commonInit(long var0);

        public static native void computeGeneralizedGravityForce(long var0, long var2);

        public static native void computeGravityCompensation(long var0, long var2);

        public static native void computeCoriolisAndCentrifugalForce(long var0, long var2);

        public static native void computeCoriolisCompensation(long var0, long var2);

        public static native void computeGeneralizedExternalForce(long var0, long var2);

        public static native void computeJointAcceleration(long var0, long var2);

        public static native void computeJointForce(long var0, long var2);

        public static native void computeCoefficientMatrix(long var0, long var2);

        public static native void computeGeneralizedMassMatrix(long var0, long var2);

        public static native void computeMassMatrix(long var0, long var2);

        public static native long computeArticulationCOM(long var0, boolean var2);

        public static native void computeCentroidalMomentumMatrix(long var0, long var2);

        public static native void addLoopJoint(long var0, long var2);

        public static native void removeLoopJoint(long var0, long var2);

        public static native int getNbLoopJoints(long var0);

        public static native int getCoefficientMatrixSize(long var0);

        public static native void setRootGlobalPose(long var0, long var2);

        public static native void setRootGlobalPose(long var0, long var2, boolean var4);

        public static native long getRootGlobalPose(long var0);

        public static native void setRootLinearVelocity(long var0, long var2);

        public static native void setRootLinearVelocity(long var0, long var2, boolean var4);

        public static native long getRootLinearVelocity(long var0);

        public static native void setRootAngularVelocity(long var0, long var2);

        public static native void setRootAngularVelocity(long var0, long var2, boolean var4);

        public static native long getRootAngularVelocity(long var0);

        public static native long getLinkAcceleration(long var0, int var2);

        public static native int getGPUIndex(long var0);

        public static native long createSpatialTendon(long var0);

        public static native long createFixedTendon(long var0);

        public static native int getNbSpatialTendons(long var0);

        public static native int getNbFixedTendons(long var0);

        public static native void updateKinematic(long var0, long var2);
    }
}

