/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;

public class PxFilterData
extends NativeObject {
    public static final int SIZEOF = PxFilterData.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxFilterData wrapPointer(long address) {
        return address != 0L ? new PxFilterData(address) : null;
    }

    public static PxFilterData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxFilterData.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxFilterData(long address) {
        super(address);
    }

    public static PxFilterData createAt(long address) {
        Raw.PxFilterData_placed(address);
        PxFilterData createdObj = PxFilterData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxFilterData createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxFilterData_placed(address);
        PxFilterData createdObj = PxFilterData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxFilterData createAt(long address, int w0, int w1, int w2, int w3) {
        Raw.PxFilterData_placed(address, w0, w1, w2, w3);
        PxFilterData createdObj = PxFilterData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxFilterData createAt(T allocator, NativeObject.Allocator<T> allocate, int w0, int w1, int w2, int w3) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxFilterData_placed(address, w0, w1, w2, w3);
        PxFilterData createdObj = PxFilterData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxFilterData() {
        this.address = Raw.PxFilterData();
    }

    public PxFilterData(int w0, int w1, int w2, int w3) {
        this.address = Raw.PxFilterData(w0, w1, w2, w3);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getWord0() {
        this.checkNotNull();
        return Raw.getWord0(this.address);
    }

    public void setWord0(int value) {
        this.checkNotNull();
        Raw.setWord0(this.address, value);
    }

    public int getWord1() {
        this.checkNotNull();
        return Raw.getWord1(this.address);
    }

    public void setWord1(int value) {
        this.checkNotNull();
        Raw.setWord1(this.address, value);
    }

    public int getWord2() {
        this.checkNotNull();
        return Raw.getWord2(this.address);
    }

    public void setWord2(int value) {
        this.checkNotNull();
        Raw.setWord2(this.address, value);
    }

    public int getWord3() {
        this.checkNotNull();
        return Raw.getWord3(this.address);
    }

    public void setWord3(int value) {
        this.checkNotNull();
        Raw.setWord3(this.address, value);
    }

    public static class Raw {
        public static native void PxFilterData_placed(long var0);

        public static native void PxFilterData_placed(long var0, int var2, int var3, int var4, int var5);

        public static native long PxFilterData();

        public static native long PxFilterData(int var0, int var1, int var2, int var3);

        public static native void destroy(long var0);

        public static native int getWord0(long var0);

        public static native void setWord0(long var0, int var2);

        public static native int getWord1(long var0);

        public static native void setWord1(long var0, int var2);

        public static native int getWord2(long var0);

        public static native void setWord2(long var0, int var2);

        public static native int getWord3(long var0);

        public static native void setWord3(long var0, int var2);
    }
}

