/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxVec3;
import physx.physics.PxHitFlags;
import physx.physics.PxQueryHit;

public class PxLocationHit
extends PxQueryHit {
    public static final int SIZEOF = PxLocationHit.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxLocationHit() {
    }

    private static native int __sizeOf();

    public static PxLocationHit wrapPointer(long address) {
        return address != 0L ? new PxLocationHit(address) : null;
    }

    public static PxLocationHit arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxLocationHit.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxLocationHit(long address) {
        super(address);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxHitFlags getFlags() {
        this.checkNotNull();
        return PxHitFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public void setFlags(PxHitFlags value) {
        this.checkNotNull();
        Raw.setFlags(this.address, value.getAddress());
    }

    public PxVec3 getPosition() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getPosition(this.address));
    }

    public void setPosition(PxVec3 value) {
        this.checkNotNull();
        Raw.setPosition(this.address, value.getAddress());
    }

    public PxVec3 getNormal() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getNormal(this.address));
    }

    public void setNormal(PxVec3 value) {
        this.checkNotNull();
        Raw.setNormal(this.address, value.getAddress());
    }

    public float getDistance() {
        this.checkNotNull();
        return Raw.getDistance(this.address);
    }

    public void setDistance(float value) {
        this.checkNotNull();
        Raw.setDistance(this.address, value);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getFlags(long var0);

        public static native void setFlags(long var0, long var2);

        public static native long getPosition(long var0);

        public static native void setPosition(long var0, long var2);

        public static native long getNormal(long var0);

        public static native void setNormal(long var0, long var2);

        public static native float getDistance(long var0);

        public static native void setDistance(long var0, float var2);
    }
}

