/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxFoundation;
import physx.common.PxInputData;
import physx.common.PxInsertionCallback;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.geometry.PxConvexMesh;
import physx.geometry.PxGeometry;
import physx.geometry.PxTriangleMesh;
import physx.physics.PxAggregate;
import physx.physics.PxArticulationReducedCoordinate;
import physx.physics.PxMaterial;
import physx.physics.PxRigidDynamic;
import physx.physics.PxRigidStatic;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxShape;
import physx.physics.PxShapeFlags;

public class PxPhysics
extends NativeObject {
    public static final int SIZEOF = PxPhysics.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxPhysics() {
    }

    private static native int __sizeOf();

    public static PxPhysics wrapPointer(long address) {
        return address != 0L ? new PxPhysics(address) : null;
    }

    public static PxPhysics arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxPhysics.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxPhysics(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public PxFoundation getFoundation() {
        this.checkNotNull();
        return PxFoundation.wrapPointer(Raw.getFoundation(this.address));
    }

    public PxAggregate createAggregate(int maxActor, int maxShape, boolean enableSelfCollision) {
        this.checkNotNull();
        return PxAggregate.wrapPointer(Raw.createAggregate(this.address, maxActor, maxShape, enableSelfCollision));
    }

    public PxTolerancesScale getTolerancesScale() {
        this.checkNotNull();
        return PxTolerancesScale.wrapPointer(Raw.getTolerancesScale(this.address));
    }

    public PxScene createScene(PxSceneDesc sceneDesc) {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.createScene(this.address, sceneDesc.getAddress()));
    }

    public PxRigidStatic createRigidStatic(PxTransform pose) {
        this.checkNotNull();
        return PxRigidStatic.wrapPointer(Raw.createRigidStatic(this.address, pose.getAddress()));
    }

    public PxRigidDynamic createRigidDynamic(PxTransform pose) {
        this.checkNotNull();
        return PxRigidDynamic.wrapPointer(Raw.createRigidDynamic(this.address, pose.getAddress()));
    }

    public PxShape createShape(PxGeometry geometry, PxMaterial material) {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.createShape(this.address, geometry.getAddress(), material.getAddress()));
    }

    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive) {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.createShape(this.address, geometry.getAddress(), material.getAddress(), isExclusive));
    }

    public PxShape createShape(PxGeometry geometry, PxMaterial material, boolean isExclusive, PxShapeFlags shapeFlags) {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.createShape(this.address, geometry.getAddress(), material.getAddress(), isExclusive, shapeFlags.getAddress()));
    }

    public PxTriangleMesh createTriangleMesh(PxInputData stream) {
        this.checkNotNull();
        return PxTriangleMesh.wrapPointer(Raw.createTriangleMesh(this.address, stream.getAddress()));
    }

    public PxConvexMesh createConvexMesh(PxInputData stream) {
        this.checkNotNull();
        return PxConvexMesh.wrapPointer(Raw.createConvexMesh(this.address, stream.getAddress()));
    }

    public int getNbShapes() {
        this.checkNotNull();
        return Raw.getNbShapes(this.address);
    }

    public PxArticulationReducedCoordinate createArticulationReducedCoordinate() {
        this.checkNotNull();
        return PxArticulationReducedCoordinate.wrapPointer(Raw.createArticulationReducedCoordinate(this.address));
    }

    public PxMaterial createMaterial(float staticFriction, float dynamicFriction, float restitution) {
        this.checkNotNull();
        return PxMaterial.wrapPointer(Raw.createMaterial(this.address, staticFriction, dynamicFriction, restitution));
    }

    public PxInsertionCallback getPhysicsInsertionCallback() {
        this.checkNotNull();
        return PxInsertionCallback.wrapPointer(Raw.getPhysicsInsertionCallback(this.address));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void release(long var0);

        public static native long getFoundation(long var0);

        public static native long createAggregate(long var0, int var2, int var3, boolean var4);

        public static native long getTolerancesScale(long var0);

        public static native long createScene(long var0, long var2);

        public static native long createRigidStatic(long var0, long var2);

        public static native long createRigidDynamic(long var0, long var2);

        public static native long createShape(long var0, long var2, long var4);

        public static native long createShape(long var0, long var2, long var4, boolean var6);

        public static native long createShape(long var0, long var2, long var4, boolean var6, long var7);

        public static native long createTriangleMesh(long var0, long var2);

        public static native long createConvexMesh(long var0, long var2);

        public static native int getNbShapes(long var0);

        public static native long createArticulationReducedCoordinate(long var0);

        public static native long createMaterial(long var0, float var2, float var3, float var4);

        public static native long getPhysicsInsertionCallback(long var0);
    }
}

