/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.physics.PxRaycastCallback;
import physx.physics.PxRaycastHit;

public class PxRaycastBuffer10
extends PxRaycastCallback {
    public static final int SIZEOF = PxRaycastBuffer10.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxRaycastBuffer10 wrapPointer(long address) {
        return address != 0L ? new PxRaycastBuffer10(address) : null;
    }

    public static PxRaycastBuffer10 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRaycastBuffer10.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRaycastBuffer10(long address) {
        super(address);
    }

    public PxRaycastBuffer10() {
        this.address = Raw.PxRaycastBuffer10();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxRaycastHit getBlock() {
        this.checkNotNull();
        return PxRaycastHit.wrapPointer(Raw.getBlock(this.address));
    }

    public void setBlock(PxRaycastHit value) {
        this.checkNotNull();
        Raw.setBlock(this.address, value.getAddress());
    }

    public boolean getHasBlock() {
        this.checkNotNull();
        return Raw.getHasBlock(this.address);
    }

    public void setHasBlock(boolean value) {
        this.checkNotNull();
        Raw.setHasBlock(this.address, value);
    }

    public int getNbAnyHits() {
        this.checkNotNull();
        return Raw.getNbAnyHits(this.address);
    }

    public PxRaycastHit getAnyHit(int index) {
        this.checkNotNull();
        return PxRaycastHit.wrapPointer(Raw.getAnyHit(this.address, index));
    }

    public int getNbTouches() {
        this.checkNotNull();
        return Raw.getNbTouches(this.address);
    }

    public PxRaycastHit getTouches() {
        this.checkNotNull();
        return PxRaycastHit.wrapPointer(Raw.getTouches(this.address));
    }

    public PxRaycastHit getTouch(int index) {
        this.checkNotNull();
        return PxRaycastHit.wrapPointer(Raw.getTouch(this.address, index));
    }

    public int getMaxNbTouches() {
        this.checkNotNull();
        return Raw.getMaxNbTouches(this.address);
    }

    public static class Raw {
        public static native long PxRaycastBuffer10();

        public static native void destroy(long var0);

        public static native long getBlock(long var0);

        public static native void setBlock(long var0, long var2);

        public static native boolean getHasBlock(long var0);

        public static native void setHasBlock(long var0, boolean var2);

        public static native int getNbAnyHits(long var0);

        public static native long getAnyHit(long var0, int var2);

        public static native int getNbTouches(long var0);

        public static native long getTouches(long var0);

        public static native long getTouch(long var0, int var2);

        public static native int getMaxNbTouches(long var0);
    }
}

