/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamicLockFlagEnum;
import physx.physics.PxRigidDynamicLockFlags;

public class PxRigidDynamic
extends PxRigidBody {
    public static final int SIZEOF = PxRigidDynamic.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxRigidDynamic() {
    }

    private static native int __sizeOf();

    public static PxRigidDynamic wrapPointer(long address) {
        return address != 0L ? new PxRigidDynamic(address) : null;
    }

    public static PxRigidDynamic arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxRigidDynamic.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxRigidDynamic(long address) {
        super(address);
    }

    public void setKinematicTarget(PxTransform destination) {
        this.checkNotNull();
        Raw.setKinematicTarget(this.address, destination.getAddress());
    }

    public boolean getKinematicTarget(PxTransform target) {
        this.checkNotNull();
        return Raw.getKinematicTarget(this.address, target.getAddress());
    }

    public boolean isSleeping() {
        this.checkNotNull();
        return Raw.isSleeping(this.address);
    }

    public void setSleepThreshold(float threshold) {
        this.checkNotNull();
        Raw.setSleepThreshold(this.address, threshold);
    }

    public float getSleepThreshold() {
        this.checkNotNull();
        return Raw.getSleepThreshold(this.address);
    }

    public void setStabilizationThreshold(float threshold) {
        this.checkNotNull();
        Raw.setStabilizationThreshold(this.address, threshold);
    }

    public float getStabilizationThreshold() {
        this.checkNotNull();
        return Raw.getStabilizationThreshold(this.address);
    }

    public PxRigidDynamicLockFlags getRigidDynamicLockFlags() {
        this.checkNotNull();
        return PxRigidDynamicLockFlags.wrapPointer(Raw.getRigidDynamicLockFlags(this.address));
    }

    public void setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setRigidDynamicLockFlag(this.address, flag.value, value);
    }

    public void setRigidDynamicLockFlags(PxRigidDynamicLockFlags flags) {
        this.checkNotNull();
        Raw.setRigidDynamicLockFlags(this.address, flags.getAddress());
    }

    public void setLinearVelocity(PxVec3 linVel) {
        this.checkNotNull();
        Raw.setLinearVelocity(this.address, linVel.getAddress());
    }

    public void setLinearVelocity(PxVec3 linVel, boolean autowake) {
        this.checkNotNull();
        Raw.setLinearVelocity(this.address, linVel.getAddress(), autowake);
    }

    public void setAngularVelocity(PxVec3 angVel) {
        this.checkNotNull();
        Raw.setAngularVelocity(this.address, angVel.getAddress());
    }

    public void setAngularVelocity(PxVec3 angVel, boolean autowake) {
        this.checkNotNull();
        Raw.setAngularVelocity(this.address, angVel.getAddress(), autowake);
    }

    public void setWakeCounter(float wakeCounterValue) {
        this.checkNotNull();
        Raw.setWakeCounter(this.address, wakeCounterValue);
    }

    public float getWakeCounter() {
        this.checkNotNull();
        return Raw.getWakeCounter(this.address);
    }

    public void wakeUp() {
        this.checkNotNull();
        Raw.wakeUp(this.address);
    }

    public void putToSleep() {
        this.checkNotNull();
        Raw.putToSleep(this.address);
    }

    public void setSolverIterationCounts(int minPositionIters) {
        this.checkNotNull();
        Raw.setSolverIterationCounts(this.address, minPositionIters);
    }

    public void setSolverIterationCounts(int minPositionIters, int minVelocityIters) {
        this.checkNotNull();
        Raw.setSolverIterationCounts(this.address, minPositionIters, minVelocityIters);
    }

    public float getContactReportThreshold() {
        this.checkNotNull();
        return Raw.getContactReportThreshold(this.address);
    }

    public void setContactReportThreshold(float threshold) {
        this.checkNotNull();
        Raw.setContactReportThreshold(this.address, threshold);
    }

    public static class Raw {
        public static native void setKinematicTarget(long var0, long var2);

        public static native boolean getKinematicTarget(long var0, long var2);

        public static native boolean isSleeping(long var0);

        public static native void setSleepThreshold(long var0, float var2);

        public static native float getSleepThreshold(long var0);

        public static native void setStabilizationThreshold(long var0, float var2);

        public static native float getStabilizationThreshold(long var0);

        public static native long getRigidDynamicLockFlags(long var0);

        public static native void setRigidDynamicLockFlag(long var0, int var2, boolean var3);

        public static native void setRigidDynamicLockFlags(long var0, long var2);

        public static native void setLinearVelocity(long var0, long var2);

        public static native void setLinearVelocity(long var0, long var2, boolean var4);

        public static native void setAngularVelocity(long var0, long var2);

        public static native void setAngularVelocity(long var0, long var2, boolean var4);

        public static native void setWakeCounter(long var0, float var2);

        public static native float getWakeCounter(long var0);

        public static native void wakeUp(long var0);

        public static native void putToSleep(long var0);

        public static native void setSolverIterationCounts(long var0, int var2);

        public static native void setSolverIterationCounts(long var0, int var2, int var3);

        public static native float getContactReportThreshold(long var0);

        public static native void setContactReportThreshold(long var0, float var2);
    }
}

