/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.physics.PxSceneFlagEnum;

public class PxSceneFlags
extends NativeObject {
    public static final int SIZEOF = PxSceneFlags.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxSceneFlags() {
    }

    private static native int __sizeOf();

    public static PxSceneFlags wrapPointer(long address) {
        return address != 0L ? new PxSceneFlags(address) : null;
    }

    public static PxSceneFlags arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSceneFlags.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSceneFlags(long address) {
        super(address);
    }

    public static PxSceneFlags createAt(long address, int flags) {
        Raw.PxSceneFlags_placed(address, flags);
        PxSceneFlags createdObj = PxSceneFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxSceneFlags createAt(T allocator, NativeObject.Allocator<T> allocate, int flags) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxSceneFlags_placed(address, flags);
        PxSceneFlags createdObj = PxSceneFlags.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxSceneFlags(int flags) {
        this.address = Raw.PxSceneFlags(flags);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public boolean isSet(PxSceneFlagEnum flag) {
        this.checkNotNull();
        return Raw.isSet(this.address, flag.value);
    }

    public void raise(PxSceneFlagEnum flag) {
        this.checkNotNull();
        Raw.raise(this.address, flag.value);
    }

    public void clear(PxSceneFlagEnum flag) {
        this.checkNotNull();
        Raw.clear(this.address, flag.value);
    }

    public static class Raw {
        public static native void PxSceneFlags_placed(long var0, int var2);

        public static native long PxSceneFlags(int var0);

        public static native void destroy(long var0);

        public static native boolean isSet(long var0, int var2);

        public static native void raise(long var0, int var2);

        public static native void clear(long var0, int var2);
    }
}

