/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;

public class PxSceneLimits
extends NativeObject {
    public static final int SIZEOF = PxSceneLimits.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxSceneLimits wrapPointer(long address) {
        return address != 0L ? new PxSceneLimits(address) : null;
    }

    public static PxSceneLimits arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxSceneLimits.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxSceneLimits(long address) {
        super(address);
    }

    public static PxSceneLimits createAt(long address) {
        Raw.PxSceneLimits_placed(address);
        PxSceneLimits createdObj = PxSceneLimits.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxSceneLimits createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxSceneLimits_placed(address);
        PxSceneLimits createdObj = PxSceneLimits.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxSceneLimits() {
        this.address = Raw.PxSceneLimits();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getMaxNbActors() {
        this.checkNotNull();
        return Raw.getMaxNbActors(this.address);
    }

    public void setMaxNbActors(int value) {
        this.checkNotNull();
        Raw.setMaxNbActors(this.address, value);
    }

    public int getMaxNbBodies() {
        this.checkNotNull();
        return Raw.getMaxNbBodies(this.address);
    }

    public void setMaxNbBodies(int value) {
        this.checkNotNull();
        Raw.setMaxNbBodies(this.address, value);
    }

    public int getMaxNbStaticShapes() {
        this.checkNotNull();
        return Raw.getMaxNbStaticShapes(this.address);
    }

    public void setMaxNbStaticShapes(int value) {
        this.checkNotNull();
        Raw.setMaxNbStaticShapes(this.address, value);
    }

    public int getMaxNbDynamicShapes() {
        this.checkNotNull();
        return Raw.getMaxNbDynamicShapes(this.address);
    }

    public void setMaxNbDynamicShapes(int value) {
        this.checkNotNull();
        Raw.setMaxNbDynamicShapes(this.address, value);
    }

    public int getMaxNbAggregates() {
        this.checkNotNull();
        return Raw.getMaxNbAggregates(this.address);
    }

    public void setMaxNbAggregates(int value) {
        this.checkNotNull();
        Raw.setMaxNbAggregates(this.address, value);
    }

    public int getMaxNbConstraints() {
        this.checkNotNull();
        return Raw.getMaxNbConstraints(this.address);
    }

    public void setMaxNbConstraints(int value) {
        this.checkNotNull();
        Raw.setMaxNbConstraints(this.address, value);
    }

    public int getMaxNbRegions() {
        this.checkNotNull();
        return Raw.getMaxNbRegions(this.address);
    }

    public void setMaxNbRegions(int value) {
        this.checkNotNull();
        Raw.setMaxNbRegions(this.address, value);
    }

    public int getMaxNbBroadPhaseOverlaps() {
        this.checkNotNull();
        return Raw.getMaxNbBroadPhaseOverlaps(this.address);
    }

    public void setMaxNbBroadPhaseOverlaps(int value) {
        this.checkNotNull();
        Raw.setMaxNbBroadPhaseOverlaps(this.address, value);
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native void PxSceneLimits_placed(long var0);

        public static native long PxSceneLimits();

        public static native void destroy(long var0);

        public static native int getMaxNbActors(long var0);

        public static native void setMaxNbActors(long var0, int var2);

        public static native int getMaxNbBodies(long var0);

        public static native void setMaxNbBodies(long var0, int var2);

        public static native int getMaxNbStaticShapes(long var0);

        public static native void setMaxNbStaticShapes(long var0, int var2);

        public static native int getMaxNbDynamicShapes(long var0);

        public static native void setMaxNbDynamicShapes(long var0, int var2);

        public static native int getMaxNbAggregates(long var0);

        public static native void setMaxNbAggregates(long var0, int var2);

        public static native int getMaxNbConstraints(long var0);

        public static native void setMaxNbConstraints(long var0, int var2);

        public static native int getMaxNbRegions(long var0);

        public static native void setMaxNbRegions(long var0, int var2);

        public static native int getMaxNbBroadPhaseOverlaps(long var0);

        public static native void setMaxNbBroadPhaseOverlaps(long var0, int var2);

        public static native void setToDefault(long var0);

        public static native boolean isValid(long var0);
    }
}

