/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.NativeObject;
import physx.common.PxRefCounted;
import physx.common.PxTransform;
import physx.geometry.PxGeometry;
import physx.physics.PxBaseMaterial;
import physx.physics.PxFilterData;
import physx.physics.PxRigidActor;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;
import physx.support.PxMaterialPtr;

public class PxShape
extends PxRefCounted {
    public static final int SIZEOF = PxShape.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxShape() {
    }

    private static native int __sizeOf();

    public static PxShape wrapPointer(long address) {
        return address != 0L ? new PxShape(address) : null;
    }

    public static PxShape arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxShape.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxShape(long address) {
        super(address);
    }

    public NativeObject getUserData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getUserData(this.address));
    }

    public void setUserData(NativeObject value) {
        this.checkNotNull();
        Raw.setUserData(this.address, value.getAddress());
    }

    public void setGeometry(PxGeometry geometry) {
        this.checkNotNull();
        Raw.setGeometry(this.address, geometry.getAddress());
    }

    public PxGeometry getGeometry() {
        this.checkNotNull();
        return PxGeometry.wrapPointer(Raw.getGeometry(this.address));
    }

    public PxRigidActor getActor() {
        this.checkNotNull();
        return PxRigidActor.wrapPointer(Raw.getActor(this.address));
    }

    public void setMaterials(PxMaterialPtr materials, short materialCount) {
        this.checkNotNull();
        Raw.setMaterials(this.address, materials.getAddress(), materialCount);
    }

    public short getNbMaterials() {
        this.checkNotNull();
        return Raw.getNbMaterials(this.address);
    }

    public int getMaterials(PxMaterialPtr userBuffer, int bufferSize, int startIndex) {
        this.checkNotNull();
        return Raw.getMaterials(this.address, userBuffer.getAddress(), bufferSize, startIndex);
    }

    public PxBaseMaterial getMaterialFromInternalFaceIndex(int faceIndex) {
        this.checkNotNull();
        return PxBaseMaterial.wrapPointer(Raw.getMaterialFromInternalFaceIndex(this.address, faceIndex));
    }

    public void setContactOffset(float contactOffset) {
        this.checkNotNull();
        Raw.setContactOffset(this.address, contactOffset);
    }

    public float getContactOffset() {
        this.checkNotNull();
        return Raw.getContactOffset(this.address);
    }

    public void setRestOffset(float restOffset) {
        this.checkNotNull();
        Raw.setRestOffset(this.address, restOffset);
    }

    public float getRestOffset() {
        this.checkNotNull();
        return Raw.getRestOffset(this.address);
    }

    public void setTorsionalPatchRadius(float radius) {
        this.checkNotNull();
        Raw.setTorsionalPatchRadius(this.address, radius);
    }

    public float getTorsionalPatchRadius() {
        this.checkNotNull();
        return Raw.getTorsionalPatchRadius(this.address);
    }

    public void setMinTorsionalPatchRadius(float radius) {
        this.checkNotNull();
        Raw.setMinTorsionalPatchRadius(this.address, radius);
    }

    public float getMinTorsionalPatchRadius() {
        this.checkNotNull();
        return Raw.getMinTorsionalPatchRadius(this.address);
    }

    public void setFlag(PxShapeFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setFlag(this.address, flag.value, value);
    }

    public void setFlags(PxShapeFlags inFlags) {
        this.checkNotNull();
        Raw.setFlags(this.address, inFlags.getAddress());
    }

    public PxShapeFlags getFlags() {
        this.checkNotNull();
        return PxShapeFlags.wrapPointer(Raw.getFlags(this.address));
    }

    public boolean isExclusive() {
        this.checkNotNull();
        return Raw.isExclusive(this.address);
    }

    public void setName(String name) {
        this.checkNotNull();
        Raw.setName(this.address, name);
    }

    public String getName() {
        this.checkNotNull();
        return Raw.getName(this.address);
    }

    public void setLocalPose(PxTransform pose) {
        this.checkNotNull();
        Raw.setLocalPose(this.address, pose.getAddress());
    }

    public PxTransform getLocalPose() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getLocalPose(this.address));
    }

    public void setSimulationFilterData(PxFilterData data) {
        this.checkNotNull();
        Raw.setSimulationFilterData(this.address, data.getAddress());
    }

    public PxFilterData getSimulationFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getSimulationFilterData(this.address));
    }

    public void setQueryFilterData(PxFilterData data) {
        this.checkNotNull();
        Raw.setQueryFilterData(this.address, data.getAddress());
    }

    public PxFilterData getQueryFilterData() {
        this.checkNotNull();
        return PxFilterData.wrapPointer(Raw.getQueryFilterData(this.address));
    }

    public static class Raw {
        public static native long getUserData(long var0);

        public static native void setUserData(long var0, long var2);

        public static native void setGeometry(long var0, long var2);

        public static native long getGeometry(long var0);

        public static native long getActor(long var0);

        public static native void setMaterials(long var0, long var2, short var4);

        public static native short getNbMaterials(long var0);

        public static native int getMaterials(long var0, long var2, int var4, int var5);

        public static native long getMaterialFromInternalFaceIndex(long var0, int var2);

        public static native void setContactOffset(long var0, float var2);

        public static native float getContactOffset(long var0);

        public static native void setRestOffset(long var0, float var2);

        public static native float getRestOffset(long var0);

        public static native void setTorsionalPatchRadius(long var0, float var2);

        public static native float getTorsionalPatchRadius(long var0);

        public static native void setMinTorsionalPatchRadius(long var0, float var2);

        public static native float getMinTorsionalPatchRadius(long var0);

        public static native void setFlag(long var0, int var2, boolean var3);

        public static native void setFlags(long var0, long var2);

        public static native long getFlags(long var0);

        public static native boolean isExclusive(long var0);

        public static native void setName(long var0, String var2);

        public static native String getName(long var0);

        public static native void setLocalPose(long var0, long var2);

        public static native long getLocalPose(long var0);

        public static native void setSimulationFilterData(long var0, long var2);

        public static native long getSimulationFilterData(long var0);

        public static native void setQueryFilterData(long var0, long var2);

        public static native long getQueryFilterData(long var0);
    }
}

