/*
 * Decompiled with CFR 0.152.
 */
package physx.physics;

import physx.physics.PxConstraintInfo;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxSimulationEventCallback;
import physx.physics.PxTriggerPair;
import physx.support.PxActorPtr;

public class SimpleSimulationEventCallback
extends PxSimulationEventCallback {
    public static final int SIZEOF = SimpleSimulationEventCallback.__sizeOf();
    public static final int ALIGNOF = 8;

    protected SimpleSimulationEventCallback() {
    }

    private static native int __sizeOf();

    public static SimpleSimulationEventCallback wrapPointer(long address) {
        return address != 0L ? new SimpleSimulationEventCallback(address) : null;
    }

    public static SimpleSimulationEventCallback arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return SimpleSimulationEventCallback.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected SimpleSimulationEventCallback(long address) {
        super(address);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public void onConstraintBreak(PxConstraintInfo constraints, int count) {
        this.checkNotNull();
        Raw.onConstraintBreak(this.address, constraints.getAddress(), count);
    }

    public void onWake(PxActorPtr actors, int count) {
        this.checkNotNull();
        Raw.onWake(this.address, actors.getAddress(), count);
    }

    public void onSleep(PxActorPtr actors, int count) {
        this.checkNotNull();
        Raw.onSleep(this.address, actors.getAddress(), count);
    }

    public void onContact(PxContactPairHeader pairHeader, PxContactPair pairs, int nbPairs) {
        this.checkNotNull();
        Raw.onContact(this.address, pairHeader.getAddress(), pairs.getAddress(), nbPairs);
    }

    public void onTrigger(PxTriggerPair pairs, int count) {
        this.checkNotNull();
        Raw.onTrigger(this.address, pairs.getAddress(), count);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native void onConstraintBreak(long var0, long var2, int var4);

        public static native void onWake(long var0, long var2, int var4);

        public static native void onSleep(long var0, long var2, int var4);

        public static native void onContact(long var0, long var2, long var4, int var6);

        public static native void onTrigger(long var0, long var2, int var4);
    }
}

