/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;
import physx.character.PxController;
import physx.character.PxControllerObstacleHit;
import physx.character.PxControllerShapeHit;
import physx.character.PxControllersHit;
import physx.character.PxObstacle;
import physx.common.PxBounds3;
import physx.common.PxDebugLine;
import physx.common.PxDebugPoint;
import physx.common.PxDebugTriangle;
import physx.common.PxVec3;
import physx.physics.PxActor;
import physx.physics.PxContactPair;
import physx.physics.PxContactPairHeader;
import physx.physics.PxShape;
import physx.physics.PxTriggerPair;
import physx.support.PxI32Ptr;
import physx.support.PxRealPtr;
import physx.support.PxU16ConstPtr;
import physx.support.PxU16Ptr;
import physx.support.PxU32ConstPtr;
import physx.support.PxU32Ptr;
import physx.support.PxU8ConstPtr;
import physx.support.PxU8Ptr;

public class NativeArrayHelpers
extends NativeObject {
    public static final int SIZEOF = NativeArrayHelpers.__sizeOf();
    public static final int ALIGNOF = 8;

    protected NativeArrayHelpers() {
    }

    private static native int __sizeOf();

    public static NativeArrayHelpers wrapPointer(long address) {
        return address != 0L ? new NativeArrayHelpers(address) : null;
    }

    public static NativeArrayHelpers arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return NativeArrayHelpers.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected NativeArrayHelpers(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static byte getU8At(PxU8ConstPtr base, int index) {
        return Raw.getU8At(base.getAddress(), index);
    }

    public static short getU16At(PxU16ConstPtr base, int index) {
        return Raw.getU16At(base.getAddress(), index);
    }

    public static int getU32At(PxU32ConstPtr base, int index) {
        return Raw.getU32At(base.getAddress(), index);
    }

    public static float getRealAt(PxRealPtr base, int index) {
        return Raw.getRealAt(base.getAddress(), index);
    }

    public static void setU8At(NativeObject base, int index, byte value) {
        Raw.setU8At(base.getAddress(), index, value);
    }

    public static void setU16At(NativeObject base, int index, short value) {
        Raw.setU16At(base.getAddress(), index, value);
    }

    public static void setU32At(NativeObject base, int index, int value) {
        Raw.setU32At(base.getAddress(), index, value);
    }

    public static void setRealAt(NativeObject base, int index, float value) {
        Raw.setRealAt(base.getAddress(), index, value);
    }

    public static PxU8Ptr voidToU8Ptr(NativeObject voidPtr) {
        return PxU8Ptr.wrapPointer(Raw.voidToU8Ptr(voidPtr.getAddress()));
    }

    public static PxU16Ptr voidToU16Ptr(NativeObject voidPtr) {
        return PxU16Ptr.wrapPointer(Raw.voidToU16Ptr(voidPtr.getAddress()));
    }

    public static PxU32Ptr voidToU32Ptr(NativeObject voidPtr) {
        return PxU32Ptr.wrapPointer(Raw.voidToU32Ptr(voidPtr.getAddress()));
    }

    public static PxI32Ptr voidToI32Ptr(NativeObject voidPtr) {
        return PxI32Ptr.wrapPointer(Raw.voidToI32Ptr(voidPtr.getAddress()));
    }

    public static PxRealPtr voidToRealPtr(NativeObject voidPtr) {
        return PxRealPtr.wrapPointer(Raw.voidToRealPtr(voidPtr.getAddress()));
    }

    public static PxActor getActorAt(PxActor base, int index) {
        return PxActor.wrapPointer(Raw.getActorAt(base.getAddress(), index));
    }

    public static PxBounds3 getBounds3At(PxBounds3 base, int index) {
        return PxBounds3.wrapPointer(Raw.getBounds3At(base.getAddress(), index));
    }

    public static PxContactPair getContactPairAt(PxContactPair base, int index) {
        return PxContactPair.wrapPointer(Raw.getContactPairAt(base.getAddress(), index));
    }

    public static PxContactPairHeader getContactPairHeaderAt(PxContactPairHeader base, int index) {
        return PxContactPairHeader.wrapPointer(Raw.getContactPairHeaderAt(base.getAddress(), index));
    }

    public static PxController getControllerAt(PxController base, int index) {
        return PxController.wrapPointer(Raw.getControllerAt(base.getAddress(), index));
    }

    public static PxControllerShapeHit getControllerShapeHitAt(PxControllerShapeHit base, int index) {
        return PxControllerShapeHit.wrapPointer(Raw.getControllerShapeHitAt(base.getAddress(), index));
    }

    public static PxControllersHit getControllersHitAt(PxControllersHit base, int index) {
        return PxControllersHit.wrapPointer(Raw.getControllersHitAt(base.getAddress(), index));
    }

    public static PxControllerObstacleHit getControllerObstacleHitAt(PxControllerObstacleHit base, int index) {
        return PxControllerObstacleHit.wrapPointer(Raw.getControllerObstacleHitAt(base.getAddress(), index));
    }

    public static PxDebugPoint getDebugPointAt(PxDebugPoint base, int index) {
        return PxDebugPoint.wrapPointer(Raw.getDebugPointAt(base.getAddress(), index));
    }

    public static PxDebugLine getDebugLineAt(PxDebugLine base, int index) {
        return PxDebugLine.wrapPointer(Raw.getDebugLineAt(base.getAddress(), index));
    }

    public static PxDebugTriangle getDebugTriangleAt(PxDebugTriangle base, int index) {
        return PxDebugTriangle.wrapPointer(Raw.getDebugTriangleAt(base.getAddress(), index));
    }

    public static PxObstacle getObstacleAt(PxObstacle base, int index) {
        return PxObstacle.wrapPointer(Raw.getObstacleAt(base.getAddress(), index));
    }

    public static PxShape getShapeAt(PxShape base, int index) {
        return PxShape.wrapPointer(Raw.getShapeAt(base.getAddress(), index));
    }

    public static PxTriggerPair getTriggerPairAt(PxTriggerPair base, int index) {
        return PxTriggerPair.wrapPointer(Raw.getTriggerPairAt(base.getAddress(), index));
    }

    public static PxVec3 getVec3At(PxVec3 base, int index) {
        return PxVec3.wrapPointer(Raw.getVec3At(base.getAddress(), index));
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native byte getU8At(long var0, int var2);

        public static native short getU16At(long var0, int var2);

        public static native int getU32At(long var0, int var2);

        public static native float getRealAt(long var0, int var2);

        public static native void setU8At(long var0, int var2, byte var3);

        public static native void setU16At(long var0, int var2, short var3);

        public static native void setU32At(long var0, int var2, int var3);

        public static native void setRealAt(long var0, int var2, float var3);

        public static native long voidToU8Ptr(long var0);

        public static native long voidToU16Ptr(long var0);

        public static native long voidToU32Ptr(long var0);

        public static native long voidToI32Ptr(long var0);

        public static native long voidToRealPtr(long var0);

        public static native long getActorAt(long var0, int var2);

        public static native long getBounds3At(long var0, int var2);

        public static native long getContactPairAt(long var0, int var2);

        public static native long getContactPairHeaderAt(long var0, int var2);

        public static native long getControllerAt(long var0, int var2);

        public static native long getControllerShapeHitAt(long var0, int var2);

        public static native long getControllersHitAt(long var0, int var2);

        public static native long getControllerObstacleHitAt(long var0, int var2);

        public static native long getDebugPointAt(long var0, int var2);

        public static native long getDebugLineAt(long var0, int var2);

        public static native long getDebugTriangleAt(long var0, int var2);

        public static native long getObstacleAt(long var0, int var2);

        public static native long getShapeAt(long var0, int var2);

        public static native long getTriggerPairAt(long var0, int var2);

        public static native long getVec3At(long var0, int var2);
    }
}

