/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;

public class PxArray_PxU16
extends NativeObject {
    public static final int SIZEOF = PxArray_PxU16.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxArray_PxU16 wrapPointer(long address) {
        return address != 0L ? new PxArray_PxU16(address) : null;
    }

    public static PxArray_PxU16 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxArray_PxU16.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxArray_PxU16(long address) {
        super(address);
    }

    public static PxArray_PxU16 createAt(long address) {
        Raw.PxArray_PxU16_placed(address);
        PxArray_PxU16 createdObj = PxArray_PxU16.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxU16 createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxU16_placed(address);
        PxArray_PxU16 createdObj = PxArray_PxU16.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxArray_PxU16 createAt(long address, int size) {
        Raw.PxArray_PxU16_placed(address, size);
        PxArray_PxU16 createdObj = PxArray_PxU16.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxArray_PxU16 createAt(T allocator, NativeObject.Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxArray_PxU16_placed(address, size);
        PxArray_PxU16 createdObj = PxArray_PxU16.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxArray_PxU16() {
        this.address = Raw.PxArray_PxU16();
    }

    public PxArray_PxU16(int size) {
        this.address = Raw.PxArray_PxU16(size);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public short get(int index) {
        this.checkNotNull();
        return Raw.get(this.address, index);
    }

    public void set(int index, short value) {
        this.checkNotNull();
        Raw.set(this.address, index, value);
    }

    public NativeObject begin() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.begin(this.address));
    }

    public int size() {
        this.checkNotNull();
        return Raw.size(this.address);
    }

    public void pushBack(short value) {
        this.checkNotNull();
        Raw.pushBack(this.address, value);
    }

    public void clear() {
        this.checkNotNull();
        Raw.clear(this.address);
    }

    public static class Raw {
        public static native void PxArray_PxU16_placed(long var0);

        public static native void PxArray_PxU16_placed(long var0, int var2);

        public static native long PxArray_PxU16();

        public static native long PxArray_PxU16(int var0);

        public static native void destroy(long var0);

        public static native short get(long var0, int var2);

        public static native void set(long var0, int var2, short var3);

        public static native long begin(long var0);

        public static native int size(long var0);

        public static native void pushBack(long var0, short var2);

        public static native void clear(long var0);
    }
}

