/*
 * Decompiled with CFR 0.152.
 */
package physx.support;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.support.OmniPvdFileWriteStream;
import physx.support.OmniPvdWriter;

public class PxOmniPvd
extends NativeObject {
    public static final int SIZEOF = PxOmniPvd.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxOmniPvd() {
    }

    private static native int __sizeOf();

    public static PxOmniPvd wrapPointer(long address) {
        return address != 0L ? new PxOmniPvd(address) : null;
    }

    public static PxOmniPvd arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxOmniPvd.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxOmniPvd(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public OmniPvdWriter getWriter() {
        this.checkNotNull();
        PlatformChecks.requirePlatform(7, "physx.support.PxOmniPvd");
        return OmniPvdWriter.wrapPointer(Raw.getWriter(this.address));
    }

    public OmniPvdFileWriteStream getFileWriteStream() {
        this.checkNotNull();
        PlatformChecks.requirePlatform(7, "physx.support.PxOmniPvd");
        return OmniPvdFileWriteStream.wrapPointer(Raw.getFileWriteStream(this.address));
    }

    public boolean startSampling() {
        this.checkNotNull();
        return Raw.startSampling(this.address);
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getWriter(long var0);

        public static native long getFileWriteStream(long var0);

        public static native boolean startSampling(long var0);

        public static native void release(long var0);
    }
}

