/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.vehicle2.BaseVehicleParams;
import physx.vehicle2.BaseVehicleState;
import physx.vehicle2.PxVehicleComponentSequence;
import physx.vehicle2.PxVehicleSimulationContext;

public class BaseVehicle
extends NativeObject {
    public static final int SIZEOF = BaseVehicle.__sizeOf();
    public static final int ALIGNOF = 8;

    protected BaseVehicle() {
    }

    private static native int __sizeOf();

    public static BaseVehicle wrapPointer(long address) {
        return address != 0L ? new BaseVehicle(address) : null;
    }

    public static BaseVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return BaseVehicle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected BaseVehicle(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public BaseVehicleParams getBaseParams() {
        this.checkNotNull();
        return BaseVehicleParams.wrapPointer(Raw.getBaseParams(this.address));
    }

    public void setBaseParams(BaseVehicleParams value) {
        this.checkNotNull();
        Raw.setBaseParams(this.address, value.getAddress());
    }

    public BaseVehicleState getBaseState() {
        this.checkNotNull();
        return BaseVehicleState.wrapPointer(Raw.getBaseState(this.address));
    }

    public void setBaseState(BaseVehicleState value) {
        this.checkNotNull();
        Raw.setBaseState(this.address, value.getAddress());
    }

    public PxVehicleComponentSequence getComponentSequence() {
        this.checkNotNull();
        return PxVehicleComponentSequence.wrapPointer(Raw.getComponentSequence(this.address));
    }

    public void setComponentSequence(PxVehicleComponentSequence value) {
        this.checkNotNull();
        Raw.setComponentSequence(this.address, value.getAddress());
    }

    public byte getComponentSequenceSubstepGroupHandle() {
        this.checkNotNull();
        return Raw.getComponentSequenceSubstepGroupHandle(this.address);
    }

    public void setComponentSequenceSubstepGroupHandle(byte value) {
        this.checkNotNull();
        Raw.setComponentSequenceSubstepGroupHandle(this.address, value);
    }

    public boolean initialize() {
        this.checkNotNull();
        return Raw.initialize(this.address);
    }

    public void destroyState() {
        this.checkNotNull();
        Raw.destroyState(this.address);
    }

    public void initComponentSequence(boolean addPhysXBeginEndComponents) {
        this.checkNotNull();
        Raw.initComponentSequence(this.address, addPhysXBeginEndComponents);
    }

    public void step(float dt, PxVehicleSimulationContext context) {
        this.checkNotNull();
        Raw.step(this.address, dt, context.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getBaseParams(long var0);

        public static native void setBaseParams(long var0, long var2);

        public static native long getBaseState(long var0);

        public static native void setBaseState(long var0, long var2);

        public static native long getComponentSequence(long var0);

        public static native void setComponentSequence(long var0, long var2);

        public static native byte getComponentSequenceSubstepGroupHandle(long var0);

        public static native void setComponentSequenceSubstepGroupHandle(long var0, byte var2);

        public static native boolean initialize(long var0);

        public static native void destroyState(long var0);

        public static native void initComponentSequence(long var0, boolean var2);

        public static native void step(long var0, float var2, long var3);
    }
}

