/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.vehicle2.PxVehicleAckermannParams;
import physx.vehicle2.PxVehicleAntiRollForceParams;
import physx.vehicle2.PxVehicleAxleDescription;
import physx.vehicle2.PxVehicleBrakeCommandResponseParams;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehicleRigidBodyParams;
import physx.vehicle2.PxVehicleScale;
import physx.vehicle2.PxVehicleSteerCommandResponseParams;
import physx.vehicle2.PxVehicleSuspensionComplianceParams;
import physx.vehicle2.PxVehicleSuspensionForceParams;
import physx.vehicle2.PxVehicleSuspensionParams;
import physx.vehicle2.PxVehicleSuspensionStateCalculationParams;
import physx.vehicle2.PxVehicleTireForceParams;
import physx.vehicle2.PxVehicleWheelParams;

public class BaseVehicleParams
extends NativeObject {
    public static final int SIZEOF = BaseVehicleParams.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static BaseVehicleParams wrapPointer(long address) {
        return address != 0L ? new BaseVehicleParams(address) : null;
    }

    public static BaseVehicleParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return BaseVehicleParams.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected BaseVehicleParams(long address) {
        super(address);
    }

    public BaseVehicleParams() {
        this.address = Raw.BaseVehicleParams();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVehicleAxleDescription getAxleDescription() {
        this.checkNotNull();
        return PxVehicleAxleDescription.wrapPointer(Raw.getAxleDescription(this.address));
    }

    public void setAxleDescription(PxVehicleAxleDescription value) {
        this.checkNotNull();
        Raw.setAxleDescription(this.address, value.getAddress());
    }

    public PxVehicleFrame getFrame() {
        this.checkNotNull();
        return PxVehicleFrame.wrapPointer(Raw.getFrame(this.address));
    }

    public void setFrame(PxVehicleFrame value) {
        this.checkNotNull();
        Raw.setFrame(this.address, value.getAddress());
    }

    public PxVehicleScale getScale() {
        this.checkNotNull();
        return PxVehicleScale.wrapPointer(Raw.getScale(this.address));
    }

    public void setScale(PxVehicleScale value) {
        this.checkNotNull();
        Raw.setScale(this.address, value.getAddress());
    }

    public PxVehicleSuspensionStateCalculationParams getSuspensionStateCalculationParams() {
        this.checkNotNull();
        return PxVehicleSuspensionStateCalculationParams.wrapPointer(Raw.getSuspensionStateCalculationParams(this.address));
    }

    public void setSuspensionStateCalculationParams(PxVehicleSuspensionStateCalculationParams value) {
        this.checkNotNull();
        Raw.setSuspensionStateCalculationParams(this.address, value.getAddress());
    }

    public PxVehicleBrakeCommandResponseParams getBrakeResponseParams(int index) {
        this.checkNotNull();
        return PxVehicleBrakeCommandResponseParams.wrapPointer(Raw.getBrakeResponseParams(this.address, index));
    }

    public void setBrakeResponseParams(int index, PxVehicleBrakeCommandResponseParams value) {
        this.checkNotNull();
        Raw.setBrakeResponseParams(this.address, index, value.getAddress());
    }

    public PxVehicleSteerCommandResponseParams getSteerResponseParams() {
        this.checkNotNull();
        return PxVehicleSteerCommandResponseParams.wrapPointer(Raw.getSteerResponseParams(this.address));
    }

    public void setSteerResponseParams(PxVehicleSteerCommandResponseParams value) {
        this.checkNotNull();
        Raw.setSteerResponseParams(this.address, value.getAddress());
    }

    public PxVehicleAckermannParams getAckermannParams(int index) {
        this.checkNotNull();
        return PxVehicleAckermannParams.wrapPointer(Raw.getAckermannParams(this.address, index));
    }

    public void setAckermannParams(int index, PxVehicleAckermannParams value) {
        this.checkNotNull();
        Raw.setAckermannParams(this.address, index, value.getAddress());
    }

    public PxVehicleSuspensionParams getSuspensionParams(int index) {
        this.checkNotNull();
        return PxVehicleSuspensionParams.wrapPointer(Raw.getSuspensionParams(this.address, index));
    }

    public void setSuspensionParams(int index, PxVehicleSuspensionParams value) {
        this.checkNotNull();
        Raw.setSuspensionParams(this.address, index, value.getAddress());
    }

    public PxVehicleSuspensionComplianceParams getSuspensionComplianceParams(int index) {
        this.checkNotNull();
        return PxVehicleSuspensionComplianceParams.wrapPointer(Raw.getSuspensionComplianceParams(this.address, index));
    }

    public void setSuspensionComplianceParams(int index, PxVehicleSuspensionComplianceParams value) {
        this.checkNotNull();
        Raw.setSuspensionComplianceParams(this.address, index, value.getAddress());
    }

    public PxVehicleSuspensionForceParams getSuspensionForceParams(int index) {
        this.checkNotNull();
        return PxVehicleSuspensionForceParams.wrapPointer(Raw.getSuspensionForceParams(this.address, index));
    }

    public void setSuspensionForceParams(int index, PxVehicleSuspensionForceParams value) {
        this.checkNotNull();
        Raw.setSuspensionForceParams(this.address, index, value.getAddress());
    }

    public PxVehicleAntiRollForceParams getAntiRollForceParams(int index) {
        this.checkNotNull();
        return PxVehicleAntiRollForceParams.wrapPointer(Raw.getAntiRollForceParams(this.address, index));
    }

    public void setAntiRollForceParams(int index, PxVehicleAntiRollForceParams value) {
        this.checkNotNull();
        Raw.setAntiRollForceParams(this.address, index, value.getAddress());
    }

    public int getNbAntiRollForceParams() {
        this.checkNotNull();
        return Raw.getNbAntiRollForceParams(this.address);
    }

    public void setNbAntiRollForceParams(int value) {
        this.checkNotNull();
        Raw.setNbAntiRollForceParams(this.address, value);
    }

    public PxVehicleTireForceParams getTireForceParams(int index) {
        this.checkNotNull();
        return PxVehicleTireForceParams.wrapPointer(Raw.getTireForceParams(this.address, index));
    }

    public void setTireForceParams(int index, PxVehicleTireForceParams value) {
        this.checkNotNull();
        Raw.setTireForceParams(this.address, index, value.getAddress());
    }

    public PxVehicleWheelParams getWheelParams(int index) {
        this.checkNotNull();
        return PxVehicleWheelParams.wrapPointer(Raw.getWheelParams(this.address, index));
    }

    public void setWheelParams(int index, PxVehicleWheelParams value) {
        this.checkNotNull();
        Raw.setWheelParams(this.address, index, value.getAddress());
    }

    public PxVehicleRigidBodyParams getRigidBodyParams() {
        this.checkNotNull();
        return PxVehicleRigidBodyParams.wrapPointer(Raw.getRigidBodyParams(this.address));
    }

    public void setRigidBodyParams(PxVehicleRigidBodyParams value) {
        this.checkNotNull();
        Raw.setRigidBodyParams(this.address, value.getAddress());
    }

    public BaseVehicleParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return BaseVehicleParams.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long BaseVehicleParams();

        public static native void destroy(long var0);

        public static native long getAxleDescription(long var0);

        public static native void setAxleDescription(long var0, long var2);

        public static native long getFrame(long var0);

        public static native void setFrame(long var0, long var2);

        public static native long getScale(long var0);

        public static native void setScale(long var0, long var2);

        public static native long getSuspensionStateCalculationParams(long var0);

        public static native void setSuspensionStateCalculationParams(long var0, long var2);

        public static native long getBrakeResponseParams(long var0, int var2);

        public static native void setBrakeResponseParams(long var0, int var2, long var3);

        public static native long getSteerResponseParams(long var0);

        public static native void setSteerResponseParams(long var0, long var2);

        public static native long getAckermannParams(long var0, int var2);

        public static native void setAckermannParams(long var0, int var2, long var3);

        public static native long getSuspensionParams(long var0, int var2);

        public static native void setSuspensionParams(long var0, int var2, long var3);

        public static native long getSuspensionComplianceParams(long var0, int var2);

        public static native void setSuspensionComplianceParams(long var0, int var2, long var3);

        public static native long getSuspensionForceParams(long var0, int var2);

        public static native void setSuspensionForceParams(long var0, int var2, long var3);

        public static native long getAntiRollForceParams(long var0, int var2);

        public static native void setAntiRollForceParams(long var0, int var2, long var3);

        public static native int getNbAntiRollForceParams(long var0);

        public static native void setNbAntiRollForceParams(long var0, int var2);

        public static native long getTireForceParams(long var0, int var2);

        public static native void setTireForceParams(long var0, int var2, long var3);

        public static native long getWheelParams(long var0, int var2);

        public static native void setWheelParams(long var0, int var2, long var3);

        public static native long getRigidBodyParams(long var0);

        public static native void setRigidBodyParams(long var0, long var2);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);

        public static native boolean isValid(long var0);
    }
}

