/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;
import physx.vehicle2.BaseVehicle;
import physx.vehicle2.PhysXIntegrationParams;
import physx.vehicle2.PhysXIntegrationState;
import physx.vehicle2.PxVehicleCommandState;

public class PhysXActorVehicle
extends BaseVehicle {
    public static final int SIZEOF = PhysXActorVehicle.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PhysXActorVehicle() {
    }

    private static native int __sizeOf();

    public static PhysXActorVehicle wrapPointer(long address) {
        return address != 0L ? new PhysXActorVehicle(address) : null;
    }

    public static PhysXActorVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PhysXActorVehicle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PhysXActorVehicle(long address) {
        super(address);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PhysXIntegrationParams getPhysXParams() {
        this.checkNotNull();
        return PhysXIntegrationParams.wrapPointer(Raw.getPhysXParams(this.address));
    }

    public void setPhysXParams(PhysXIntegrationParams value) {
        this.checkNotNull();
        Raw.setPhysXParams(this.address, value.getAddress());
    }

    public PhysXIntegrationState getPhysXState() {
        this.checkNotNull();
        return PhysXIntegrationState.wrapPointer(Raw.getPhysXState(this.address));
    }

    public void setPhysXState(PhysXIntegrationState value) {
        this.checkNotNull();
        Raw.setPhysXState(this.address, value.getAddress());
    }

    public PxVehicleCommandState getCommandState() {
        this.checkNotNull();
        return PxVehicleCommandState.wrapPointer(Raw.getCommandState(this.address));
    }

    public void setCommandState(PxVehicleCommandState value) {
        this.checkNotNull();
        Raw.setCommandState(this.address, value.getAddress());
    }

    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial) {
        this.checkNotNull();
        return Raw.initialize(this.address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native long getPhysXParams(long var0);

        public static native void setPhysXParams(long var0, long var2);

        public static native long getPhysXState(long var0);

        public static native void setPhysXState(long var0, long var2);

        public static native long getCommandState(long var0);

        public static native void setCommandState(long var0, long var2);

        public static native boolean initialize(long var0, long var2, long var4, long var6);
    }
}

