/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxMat33;
import physx.vehicle2.PxVehicleAxesEnum;

public class PxVehicleFrame
extends NativeObject {
    public static final int SIZEOF = PxVehicleFrame.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleFrame wrapPointer(long address) {
        return address != 0L ? new PxVehicleFrame(address) : null;
    }

    public static PxVehicleFrame arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleFrame.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleFrame(long address) {
        super(address);
    }

    public PxVehicleFrame() {
        this.address = Raw.PxVehicleFrame();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVehicleAxesEnum getLngAxis() {
        this.checkNotNull();
        return PxVehicleAxesEnum.forValue(Raw.getLngAxis(this.address));
    }

    public void setLngAxis(PxVehicleAxesEnum value) {
        this.checkNotNull();
        Raw.setLngAxis(this.address, value.value);
    }

    public PxVehicleAxesEnum getLatAxis() {
        this.checkNotNull();
        return PxVehicleAxesEnum.forValue(Raw.getLatAxis(this.address));
    }

    public void setLatAxis(PxVehicleAxesEnum value) {
        this.checkNotNull();
        Raw.setLatAxis(this.address, value.value);
    }

    public PxVehicleAxesEnum getVrtAxis() {
        this.checkNotNull();
        return PxVehicleAxesEnum.forValue(Raw.getVrtAxis(this.address));
    }

    public void setVrtAxis(PxVehicleAxesEnum value) {
        this.checkNotNull();
        Raw.setVrtAxis(this.address, value.value);
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public PxMat33 getFrame() {
        this.checkNotNull();
        return PxMat33.wrapPointer(Raw.getFrame(this.address));
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public static class Raw {
        public static native long PxVehicleFrame();

        public static native void destroy(long var0);

        public static native int getLngAxis(long var0);

        public static native void setLngAxis(long var0, int var2);

        public static native int getLatAxis(long var0);

        public static native void setLatAxis(long var0, int var2);

        public static native int getVrtAxis(long var0);

        public static native void setVrtAxis(long var0, int var2);

        public static native void setToDefault(long var0);

        public static native long getFrame(long var0);

        public static native boolean isValid(long var0);
    }
}

