/*
 * Decompiled with CFR 0.152.
 */
package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.vehicle2.PxVehicleFrame;
import physx.vehicle2.PxVehiclePvdContext;
import physx.vehicle2.PxVehicleScale;
import physx.vehicle2.PxVehicleSimulationContextTypeEnum;
import physx.vehicle2.PxVehicleTireSlipParams;
import physx.vehicle2.PxVehicleTireStickyParams;

public class PxVehicleSimulationContext
extends NativeObject {
    public static final int SIZEOF = PxVehicleSimulationContext.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVehicleSimulationContext wrapPointer(long address) {
        return address != 0L ? new PxVehicleSimulationContext(address) : null;
    }

    public static PxVehicleSimulationContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVehicleSimulationContext.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVehicleSimulationContext(long address) {
        super(address);
    }

    public PxVehicleSimulationContext() {
        this.address = Raw.PxVehicleSimulationContext();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getGravity() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getGravity(this.address));
    }

    public void setGravity(PxVec3 value) {
        this.checkNotNull();
        Raw.setGravity(this.address, value.getAddress());
    }

    public PxVehicleFrame getFrame() {
        this.checkNotNull();
        return PxVehicleFrame.wrapPointer(Raw.getFrame(this.address));
    }

    public void setFrame(PxVehicleFrame value) {
        this.checkNotNull();
        Raw.setFrame(this.address, value.getAddress());
    }

    public PxVehicleScale getScale() {
        this.checkNotNull();
        return PxVehicleScale.wrapPointer(Raw.getScale(this.address));
    }

    public void setScale(PxVehicleScale value) {
        this.checkNotNull();
        Raw.setScale(this.address, value.getAddress());
    }

    public PxVehicleTireSlipParams getTireSlipParams() {
        this.checkNotNull();
        return PxVehicleTireSlipParams.wrapPointer(Raw.getTireSlipParams(this.address));
    }

    public void setTireSlipParams(PxVehicleTireSlipParams value) {
        this.checkNotNull();
        Raw.setTireSlipParams(this.address, value.getAddress());
    }

    public PxVehicleTireStickyParams getTireStickyParams() {
        this.checkNotNull();
        return PxVehicleTireStickyParams.wrapPointer(Raw.getTireStickyParams(this.address));
    }

    public void setTireStickyParams(PxVehicleTireStickyParams value) {
        this.checkNotNull();
        Raw.setTireStickyParams(this.address, value.getAddress());
    }

    public float getThresholdForwardSpeedForWheelAngleIntegration() {
        this.checkNotNull();
        return Raw.getThresholdForwardSpeedForWheelAngleIntegration(this.address);
    }

    public void setThresholdForwardSpeedForWheelAngleIntegration(float value) {
        this.checkNotNull();
        Raw.setThresholdForwardSpeedForWheelAngleIntegration(this.address, value);
    }

    public PxVehiclePvdContext getPvdContext() {
        this.checkNotNull();
        return PxVehiclePvdContext.wrapPointer(Raw.getPvdContext(this.address));
    }

    public void setPvdContext(PxVehiclePvdContext value) {
        this.checkNotNull();
        Raw.setPvdContext(this.address, value.getAddress());
    }

    public PxVehicleSimulationContextTypeEnum getType() {
        this.checkNotNull();
        return PxVehicleSimulationContextTypeEnum.forValue(Raw.getType(this.address));
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public PxVehicleSimulationContext transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        this.checkNotNull();
        return PxVehicleSimulationContext.wrapPointer(Raw.transformAndScale(this.address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }

    public static class Raw {
        public static native long PxVehicleSimulationContext();

        public static native void destroy(long var0);

        public static native long getGravity(long var0);

        public static native void setGravity(long var0, long var2);

        public static native long getFrame(long var0);

        public static native void setFrame(long var0, long var2);

        public static native long getScale(long var0);

        public static native void setScale(long var0, long var2);

        public static native long getTireSlipParams(long var0);

        public static native void setTireSlipParams(long var0, long var2);

        public static native long getTireStickyParams(long var0);

        public static native void setTireStickyParams(long var0, long var2);

        public static native float getThresholdForwardSpeedForWheelAngleIntegration(long var0);

        public static native void setThresholdForwardSpeedForWheelAngleIntegration(long var0, float var2);

        public static native long getPvdContext(long var0);

        public static native void setPvdContext(long var0, long var2);

        public static native int getType(long var0);

        public static native void setToDefault(long var0);

        public static native long transformAndScale(long var0, long var2, long var4, long var6, long var8);
    }
}

