/*
 * Decompiled with CFR 0.152.
 */
package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDParameters
extends NativeObject {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static VHACDParameters wrapPointer(long address) {
        return address != 0L ? new VHACDParameters(address) : null;
    }

    public static VHACDParameters arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return VHACDParameters.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected VHACDParameters(long address) {
        super(address);
    }

    public static VHACDParameters createAt(long address) {
        Raw.VHACDParameters_placed(address);
        VHACDParameters createdObj = VHACDParameters.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> VHACDParameters createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.VHACDParameters_placed(address);
        VHACDParameters createdObj = VHACDParameters.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public VHACDParameters() {
        this.address = Raw.VHACDParameters();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getM_maxConvexHulls() {
        this.checkNotNull();
        return Raw.getM_maxConvexHulls(this.address);
    }

    public void setM_maxConvexHulls(int value) {
        this.checkNotNull();
        Raw.setM_maxConvexHulls(this.address, value);
    }

    public int getM_resolution() {
        this.checkNotNull();
        return Raw.getM_resolution(this.address);
    }

    public void setM_resolution(int value) {
        this.checkNotNull();
        Raw.setM_resolution(this.address, value);
    }

    public double getM_minimumVolumePercentErrorAllowed() {
        this.checkNotNull();
        return Raw.getM_minimumVolumePercentErrorAllowed(this.address);
    }

    public void setM_minimumVolumePercentErrorAllowed(double value) {
        this.checkNotNull();
        Raw.setM_minimumVolumePercentErrorAllowed(this.address, value);
    }

    public int getM_maxRecursionDepth() {
        this.checkNotNull();
        return Raw.getM_maxRecursionDepth(this.address);
    }

    public void setM_maxRecursionDepth(int value) {
        this.checkNotNull();
        Raw.setM_maxRecursionDepth(this.address, value);
    }

    public boolean getM_shrinkWrap() {
        this.checkNotNull();
        return Raw.getM_shrinkWrap(this.address);
    }

    public void setM_shrinkWrap(boolean value) {
        this.checkNotNull();
        Raw.setM_shrinkWrap(this.address, value);
    }

    public int getM_maxNumVerticesPerCH() {
        this.checkNotNull();
        return Raw.getM_maxNumVerticesPerCH(this.address);
    }

    public void setM_maxNumVerticesPerCH(int value) {
        this.checkNotNull();
        Raw.setM_maxNumVerticesPerCH(this.address, value);
    }

    public boolean getM_asyncACD() {
        this.checkNotNull();
        return Raw.getM_asyncACD(this.address);
    }

    public void setM_asyncACD(boolean value) {
        this.checkNotNull();
        Raw.setM_asyncACD(this.address, value);
    }

    public int getM_minEdgeLength() {
        this.checkNotNull();
        return Raw.getM_minEdgeLength(this.address);
    }

    public void setM_minEdgeLength(int value) {
        this.checkNotNull();
        Raw.setM_minEdgeLength(this.address, value);
    }

    public boolean getM_findBestPlane() {
        this.checkNotNull();
        return Raw.getM_findBestPlane(this.address);
    }

    public void setM_findBestPlane(boolean value) {
        this.checkNotNull();
        Raw.setM_findBestPlane(this.address, value);
    }

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDParameters");
        SIZEOF = VHACDParameters.__sizeOf();
    }

    public static class Raw {
        public static native void VHACDParameters_placed(long var0);

        public static native long VHACDParameters();

        public static native void destroy(long var0);

        public static native int getM_maxConvexHulls(long var0);

        public static native void setM_maxConvexHulls(long var0, int var2);

        public static native int getM_resolution(long var0);

        public static native void setM_resolution(long var0, int var2);

        public static native double getM_minimumVolumePercentErrorAllowed(long var0);

        public static native void setM_minimumVolumePercentErrorAllowed(long var0, double var2);

        public static native int getM_maxRecursionDepth(long var0);

        public static native void setM_maxRecursionDepth(long var0, int var2);

        public static native boolean getM_shrinkWrap(long var0);

        public static native void setM_shrinkWrap(long var0, boolean var2);

        public static native int getM_maxNumVerticesPerCH(long var0);

        public static native void setM_maxNumVerticesPerCH(long var0, int var2);

        public static native boolean getM_asyncACD(long var0);

        public static native void setM_asyncACD(long var0, boolean var2);

        public static native int getM_minEdgeLength(long var0);

        public static native void setM_minEdgeLength(long var0, int var2);

        public static native boolean getM_findBestPlane(long var0);

        public static native void setM_findBestPlane(long var0, boolean var2);
    }
}

