/*
 * Decompiled with CFR 0.152.
 */
package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDTriangle
extends NativeObject {
    public static final int SIZEOF;
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static VHACDTriangle wrapPointer(long address) {
        return address != 0L ? new VHACDTriangle(address) : null;
    }

    public static VHACDTriangle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return VHACDTriangle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected VHACDTriangle(long address) {
        super(address);
    }

    public VHACDTriangle() {
        this.address = Raw.VHACDTriangle();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getMI0() {
        this.checkNotNull();
        return Raw.getMI0(this.address);
    }

    public void setMI0(int value) {
        this.checkNotNull();
        Raw.setMI0(this.address, value);
    }

    public int getMI1() {
        this.checkNotNull();
        return Raw.getMI1(this.address);
    }

    public void setMI1(int value) {
        this.checkNotNull();
        Raw.setMI1(this.address, value);
    }

    public int getMI2() {
        this.checkNotNull();
        return Raw.getMI2(this.address);
    }

    public void setMI2(int value) {
        this.checkNotNull();
        Raw.setMI2(this.address, value);
    }

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDTriangle");
        SIZEOF = VHACDTriangle.__sizeOf();
    }

    public static class Raw {
        public static native long VHACDTriangle();

        public static native void destroy(long var0);

        public static native int getMI0(long var0);

        public static native void setMI0(long var0, int var2);

        public static native int getMI1(long var0);

        public static native void setMI1(long var0, int var2);

        public static native int getMI2(long var0);

        public static native void setMI2(long var0, int var2);
    }
}

