/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts.an;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.an.AnalyzeValue;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAnalyze<T extends AnalyzeValue>
implements Cfg.FrameVisitor<T[]>,
Cfg.TravelCallBack {
    protected static final boolean DEBUG = false;
    public List<T> aValues = new ArrayList<T>();
    private final boolean reindexLocal;
    private T[] currentFrame;
    protected int localSize;
    protected IrMethod method;
    private T[] tmpFrame;

    public BaseAnalyze(IrMethod method) {
        this(method, true);
    }

    public BaseAnalyze(IrMethod method, boolean reindexLocal) {
        this.method = method;
        if (!reindexLocal) {
            int maxReg = -1;
            for (Local local : method.locals) {
                if (local.lsIndex <= maxReg) continue;
                maxReg = local.lsIndex;
            }
            this.localSize = maxReg + 1;
        } else {
            this.localSize = method.locals.size();
        }
        this.reindexLocal = reindexLocal;
    }

    public void analyze() {
        this.init();
        this.analyze0();
        this.analyzeValue();
    }

    protected void analyze0() {
        this.tmpFrame = this.newFrame(this.localSize);
        Cfg.dfs(this.method.stmts, this);
        this.tmpFrame = null;
    }

    protected void analyzeValue() {
    }

    protected void afterExec(T[] frame, Stmt stmt) {
    }

    @Override
    public T[] exec(T[] frame, Stmt stmt) {
        this.currentFrame = frame;
        try {
            Cfg.travel(stmt, (Cfg.TravelCallBack)this, false);
        }
        catch (Exception ex) {
            throw new RuntimeException("fail exe " + stmt, ex);
        }
        frame = this.currentFrame;
        this.currentFrame = null;
        this.afterExec((AnalyzeValue[])frame, stmt);
        return frame;
    }

    protected T getFromFrame(int idx) {
        return this.currentFrame[idx];
    }

    protected T[] getFrame(Stmt stmt) {
        return (AnalyzeValue[])stmt.frame;
    }

    protected void setFrame(Stmt stmt, T[] frame) {
        stmt.frame = frame;
    }

    protected void init() {
        if (this.reindexLocal) {
            int index = 0;
            for (Local local : this.method.locals) {
                local.lsIndex = index++;
            }
        }
        this.initCFG();
    }

    protected void initCFG() {
        Cfg.createCFG(this.method);
    }

    protected T[] newFrame() {
        return this.newFrame(this.localSize);
    }

    @Override
    public T[] initFirstFrame(Stmt first) {
        return this.newFrame(this.localSize);
    }

    protected abstract T[] newFrame(int var1);

    protected abstract T newValue();

    @Override
    public Local onAssign(Local local, AssignStmt as) {
        System.arraycopy(this.currentFrame, 0, this.tmpFrame, 0, this.localSize);
        this.currentFrame = this.tmpFrame;
        T aValue = this.onAssignLocal(local, as.op2);
        this.aValues.add(aValue);
        this.currentFrame[local.lsIndex] = aValue;
        return local;
    }

    protected T onAssignLocal(Local local, Value value) {
        return this.newValue();
    }

    @Override
    public Local onUse(Local local) {
        T aValue = this.currentFrame[local.lsIndex];
        this.onUseLocal(aValue, local);
        return local;
    }

    protected void onUseLocal(T aValue, Local local) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Stmt stmt = this.method.stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
            AnalyzeValue[] frame = (AnalyzeValue[])stmt.frame;
            if (frame != null) {
                for (AnalyzeValue p : frame) {
                    if (p == null) {
                        sb.append('.');
                        continue;
                    }
                    sb.append(p.toRsp());
                }
                sb.append(" | ");
            }
            sb.append(stmt).append('\n');
        }
        return sb.toString();
    }
}

