/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir;

public enum TypeClass {
    BOOLEAN("Z", true),
    INT("I", true),
    FLOAT("F", true),
    DOUBLE("D", true),
    LONG("J", true),
    OBJECT("L", true),
    VOID("V", true),
    UNKNOWN("?"),
    ZIL("s"),
    ZIFL("z"),
    ZIF("m"),
    ZI("n"),
    IF("i"),
    JD("w");

    public final String name;
    public final boolean fixed;

    private TypeClass(String use, boolean fixed) {
        this.name = use;
        this.fixed = fixed;
    }

    private TypeClass(String use) {
        this.name = use;
        this.fixed = false;
    }

    public static TypeClass clzOf(String desc) {
        switch (desc.charAt(0)) {
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'J': {
                return LONG;
            }
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'V': {
                return VOID;
            }
            case 'z': {
                return ZIFL;
            }
            case 's': {
                return ZIL;
            }
            case 'i': {
                return IF;
            }
            case 'm': {
                return ZIF;
            }
            case 'n': {
                return ZI;
            }
            case 'w': {
                return JD;
            }
        }
        return UNKNOWN;
    }

    public static TypeClass merge(TypeClass thizCls, TypeClass clz) {
        if (thizCls == clz) {
            return thizCls;
        }
        if (thizCls == UNKNOWN) {
            return clz;
        }
        if (clz == UNKNOWN) {
            return thizCls;
        }
        if (thizCls.fixed) {
            if (clz.fixed) {
                if (thizCls == INT && clz == BOOLEAN || thizCls == BOOLEAN && clz == INT) {
                    return INT;
                }
                throw new RuntimeException("Can't merge " + (Object)((Object)thizCls) + " and " + (Object)((Object)clz));
            }
            return thizCls;
        }
        if (clz.fixed) {
            return clz;
        }
        return TypeClass.merge0(thizCls, clz);
    }

    private static TypeClass merge0(TypeClass a, TypeClass b) {
        if (a == JD || b == JD) {
            throw new RuntimeException("Can't merge " + (Object)((Object)a) + " and " + (Object)((Object)b));
        }
        switch (a.ordinal()) {
            case 8: {
                switch (b.ordinal()) {
                    case 9: {
                        return ZIL;
                    }
                    case 12: {
                        return INT;
                    }
                    case 10: 
                    case 11: {
                        return ZI;
                    }
                }
            }
            case 9: {
                return b;
            }
            case 12: {
                switch (b.ordinal()) {
                    case 8: 
                    case 11: {
                        return INT;
                    }
                    case 9: 
                    case 10: {
                        return IF;
                    }
                }
            }
            case 10: {
                switch (b.ordinal()) {
                    case 12: {
                        return IF;
                    }
                    case 8: 
                    case 11: {
                        return ZI;
                    }
                    case 9: {
                        return ZIF;
                    }
                }
            }
            case 11: {
                if (b == IF) {
                    return INT;
                }
                return ZI;
            }
        }
        throw new RuntimeException();
    }

    public String toString() {
        return this.name;
    }
}

