/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.converter.IR2JConverter;
import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.Dex2Asm;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.dex.LambadaNameSafeClassAdapter;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.BaseDexFileReader;
import com.googlecode.d2j.reader.MultiDexFileReader;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class Dex2jar {
    public static Random random = new Random(0L);
    private DexExceptionHandler exceptionHandler;
    private final BaseDexFileReader reader;
    private int readerConfig;
    private int v3Config;

    private Dex2jar(BaseDexFileReader reader) {
        this.reader = reader;
        this.readerConfig |= 1;
    }

    public void doTranslate(Path dist) {
        this.doTranslate(dist, null);
    }

    public void doTranslate(ByteArrayOutputStream baos) {
        this.doTranslate(null, baos);
    }

    private static String toInternalClassName(String key) {
        if (key.endsWith(";")) {
            key = key.substring(1, key.length() - 1);
        }
        return key;
    }

    public void doTranslate(final Path dist, final ByteArrayOutputStream baos) {
        DexFileNode fileNode = new DexFileNode();
        try {
            this.reader.accept((DexFileVisitor)fileNode, this.readerConfig | 0x20);
        }
        catch (Exception ex) {
            this.exceptionHandler.handleFileException(ex);
        }
        final Map<String, String> parentsByName = fileNode.clzs.stream().filter(c -> c.superClass != null).collect(Collectors.toMap(c -> Dex2jar.toInternalClassName(c.className), c -> Dex2jar.toInternalClassName(c.superClass)));
        ClassVisitorFactory cvf = new ClassVisitorFactory(){

            @Override
            public ClassVisitor create(String name) {
                final ClassWriter cw = (Dex2jar.this.readerConfig & 0x400) == 0 ? new ClassWriter(1) : new ClassWriter(2){

                    protected String getCommonSuperClass(String type1, String type2) {
                        if (type1.equals(type2)) {
                            return type1;
                        }
                        HashSet<String> parentsOfType1 = new HashSet<String>();
                        parentsOfType1.add(type1);
                        while (parentsByName.containsKey(type1)) {
                            type1 = (String)parentsByName.get(type1);
                            parentsOfType1.add(type1);
                        }
                        while (parentsByName.containsKey(type2)) {
                            if (!parentsOfType1.contains(type2 = (String)parentsByName.get(type2))) continue;
                            return type2;
                        }
                        try {
                            return super.getCommonSuperClass(type1, type2);
                        }
                        catch (Throwable t) {
                            return "java/util/Object";
                        }
                    }
                };
                final LambadaNameSafeClassAdapter rca = new LambadaNameSafeClassAdapter((ClassVisitor)cw, (Dex2jar.this.readerConfig & 0x200) != 0);
                return new ClassVisitor(589824, (ClassVisitor)rca){

                    public void visitEnd() {
                        byte[] data;
                        super.visitEnd();
                        String className = rca.getClassName();
                        try {
                            data = cw.toByteArray();
                        }
                        catch (Exception ex) {
                            System.err.printf("ASM failed to generate .class file: %s%n", className);
                            Dex2jar.this.exceptionHandler.handleFileException(ex);
                            return;
                        }
                        try {
                            if (baos != null) {
                                byte[] classNameBytes = className.getBytes(StandardCharsets.UTF_8);
                                baos.write(ByteBuffer.allocate(4).putInt(classNameBytes.length).array());
                                baos.write(classNameBytes);
                                baos.write(ByteBuffer.allocate(4).putInt(data.length).array());
                                baos.write(data);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (dist != null) {
                                Path dist1 = dist.resolve(className + ".class");
                                Path parent = dist1.getParent();
                                if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                                    Files.createDirectories(parent, new FileAttribute[0]);
                                }
                                Files.write(dist1, data, new OpenOption[0]);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                };
            }
        };
        new ExDex2Asm(this.exceptionHandler){

            @Override
            public void convertCode(DexMethodNode methodNode, MethodVisitor mv, Dex2Asm.ClzCtx clzCtx) {
                if ((Dex2jar.this.readerConfig & 4) != 0 && methodNode.method.getName().equals("<clinit>")) {
                    return;
                }
                super.convertCode(methodNode, mv, clzCtx);
            }

            @Override
            public void optimize(IrMethod irMethod) {
                T_CLEAN_LABEL.transform(irMethod);
                T_DEAD_CODE.transform(irMethod);
                T_REMOVE_LOCAL.transform(irMethod);
                T_REMOVE_CONST.transform(irMethod);
                T_ZERO.transform(irMethod);
                if (T_NPE.transformReportChanged(irMethod)) {
                    T_DEAD_CODE.transform(irMethod);
                    T_REMOVE_LOCAL.transform(irMethod);
                    T_REMOVE_CONST.transform(irMethod);
                }
                T_NEW.transform(irMethod);
                T_FILL_ARRAY.transform(irMethod);
                T_AGG.transform(irMethod);
                T_MULTI_ARRAY.transform(irMethod);
                T_VOID_INVOKE.transform(irMethod);
                if (0 != (Dex2jar.this.v3Config & 4)) {
                    int i = 0;
                    for (Stmt p : irMethod.stmts) {
                        if (p.st != Stmt.ST.LABEL) continue;
                        LabelStmt labelStmt = (LabelStmt)p;
                        labelStmt.displayName = "L" + i++;
                    }
                    System.out.println(irMethod);
                }
                T_DEAD_CODE.transform(irMethod);
                T_REMOVE_LOCAL.transform(irMethod);
                T_REMOVE_CONST.transform(irMethod);
                T_TYPE.transform(irMethod);
                T_UNSSA.transform(irMethod);
                T_IR_2_J_REG_ASSIGN.transform(irMethod);
                T_TRIM_EX.transform(irMethod);
            }

            @Override
            public void ir2j(IrMethod irMethod, MethodVisitor mv, Dex2Asm.ClzCtx clzCtx) {
                new IR2JConverter().optimizeSynchronized(0 != (8 & Dex2jar.this.v3Config)).clzCtx(clzCtx).ir(irMethod).asm(mv).convert();
            }
        }.convertDex(fileNode, cvf);
    }

    public DexExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public BaseDexFileReader getReader() {
        return this.reader;
    }

    public Dex2jar reUseReg(boolean b) {
        this.v3Config = b ? (this.v3Config |= 1) : (this.v3Config &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar topoLogicalSort(boolean b) {
        this.v3Config = b ? (this.v3Config |= 2) : (this.v3Config &= 0xFFFFFFFD);
        return this;
    }

    public Dex2jar noCode(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 0x84) : (this.readerConfig &= 0xFFFFFF7B);
        return this;
    }

    public Dex2jar optimizeSynchronized(boolean b) {
        this.v3Config = b ? (this.v3Config |= 8) : (this.v3Config &= 0xFFFFFFF7);
        return this;
    }

    public Dex2jar printIR(boolean b) {
        this.v3Config = b ? (this.v3Config |= 4) : (this.v3Config &= 0xFFFFFFFB);
        return this;
    }

    public Dex2jar reUseReg() {
        this.v3Config |= 1;
        return this;
    }

    public Dex2jar optimizeSynchronized() {
        this.v3Config |= 8;
        return this;
    }

    public Dex2jar printIR() {
        this.v3Config |= 4;
        return this;
    }

    public Dex2jar topoLogicalSort() {
        this.v3Config |= 2;
        return this;
    }

    public void setExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Dex2jar skipDebug(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 1) : (this.readerConfig &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar skipDebug() {
        this.readerConfig |= 1;
        return this;
    }

    public void to(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            this.doTranslate(file);
        } else {
            try (FileSystem fs = Dex2jar.createZip(file);){
                this.doTranslate(fs.getPath("/", new String[0]));
            }
        }
    }

    private static FileSystem createZip(Path output) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        Files.deleteIfExists(output);
        Path parent = output.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        for (FileSystemProvider p : FileSystemProvider.installedProviders()) {
            String s = p.getScheme();
            if (!"jar".equals(s) && !"zip".equalsIgnoreCase(s)) continue;
            return p.newFileSystem(output, env);
        }
        throw new IOException("cant find zipfs support");
    }

    public Dex2jar withExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public Dex2jar skipExceptions(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 0x100) : (this.readerConfig &= 0xFFFFFEFF);
        return this;
    }

    public Dex2jar dontSanitizeNames(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 0x200) : (this.readerConfig &= 0xFFFFFDFF);
        return this;
    }

    public Dex2jar computeFrames(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 0x400) : (this.readerConfig &= 0xFFFFFBFF);
        return this;
    }

    public Dex2jar setRandom(Random random) {
        Dex2jar.random = random;
        return this;
    }

    public Dex2jar resetRandom() {
        return this.setRandom(new Random(0L));
    }

    public static Dex2jar from(byte[] in) throws IOException {
        return Dex2jar.from(MultiDexFileReader.open((byte[])in));
    }

    public static Dex2jar from(ByteBuffer in) throws IOException {
        return Dex2jar.from(MultiDexFileReader.open((byte[])in.array()));
    }

    public static Dex2jar from(BaseDexFileReader reader) {
        return new Dex2jar(reader);
    }

    public static Dex2jar from(File in) throws IOException {
        return Dex2jar.from(Files.readAllBytes(in.toPath()));
    }

    public static Dex2jar from(InputStream in) throws IOException {
        return Dex2jar.from(MultiDexFileReader.open((InputStream)in));
    }

    public static Dex2jar from(String in) throws IOException {
        return Dex2jar.from(new File(in));
    }
}

