package de.flapdoodle.os.common.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MatchPattern}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMatchPattern.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMatchPattern.of()}.
 */
@Generated(from = "MatchPattern", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMatchPattern implements MatchPattern {
  private final Pattern pattern;

  private ImmutableMatchPattern(Pattern pattern) {
    this.pattern = Objects.requireNonNull(pattern, "pattern");
  }

  private ImmutableMatchPattern(ImmutableMatchPattern original, Pattern pattern) {
    this.pattern = pattern;
  }

  /**
   * @return The value of the {@code pattern} attribute
   */
  @Override
  public Pattern pattern() {
    return pattern;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MatchPattern#pattern() pattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pattern
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMatchPattern withPattern(Pattern value) {
    if (this.pattern == value) return this;
    Pattern newValue = Objects.requireNonNull(value, "pattern");
    return new ImmutableMatchPattern(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMatchPattern} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMatchPattern
        && equalTo(0, (ImmutableMatchPattern) another);
  }

  private boolean equalTo(int synthetic, ImmutableMatchPattern another) {
    return pattern.equals(another.pattern);
  }

  /**
   * Computes a hash code from attributes: {@code pattern}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + pattern.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MatchPattern} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MatchPattern{"
        + "pattern=" + pattern
        + "}";
  }

  /**
   * Construct a new immutable {@code MatchPattern} instance.
   * @param pattern The value for the {@code pattern} attribute
   * @return An immutable MatchPattern instance
   */
  public static ImmutableMatchPattern of(Pattern pattern) {
    return new ImmutableMatchPattern(pattern);
  }

  /**
   * Creates an immutable copy of a {@link MatchPattern} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MatchPattern instance
   */
  public static ImmutableMatchPattern copyOf(MatchPattern instance) {
    if (instance instanceof ImmutableMatchPattern) {
      return (ImmutableMatchPattern) instance;
    }
    return ImmutableMatchPattern.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMatchPattern ImmutableMatchPattern}.
   * <pre>
   * ImmutableMatchPattern.builder()
   *    .pattern(regex.Pattern) // required {@link MatchPattern#pattern() pattern}
   *    .build();
   * </pre>
   * @return A new ImmutableMatchPattern builder
   */
  public static ImmutableMatchPattern.Builder builder() {
    return new ImmutableMatchPattern.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMatchPattern ImmutableMatchPattern}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MatchPattern", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PATTERN = 0x1L;
    private long initBits = 0x1L;

    private Pattern pattern;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MatchPattern} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MatchPattern instance) {
      Objects.requireNonNull(instance, "instance");
      pattern(instance.pattern());
      return this;
    }

    /**
     * Initializes the value for the {@link MatchPattern#pattern() pattern} attribute.
     * @param pattern The value for pattern 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pattern(Pattern pattern) {
      this.pattern = Objects.requireNonNull(pattern, "pattern");
      initBits &= ~INIT_BIT_PATTERN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMatchPattern ImmutableMatchPattern}.
     * @return An immutable instance of MatchPattern
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMatchPattern build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMatchPattern(null, pattern);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATTERN) != 0) attributes.add("pattern");
      return "Cannot build MatchPattern, some of required attributes are not set " + attributes;
    }
  }
}
