package de.flapdoodle.os.common.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OsReleaseFileMapEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOsReleaseFileMapEntry.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOsReleaseFileMapEntry.of()}.
 */
@Generated(from = "OsReleaseFileMapEntry", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableOsReleaseFileMapEntry
    implements OsReleaseFileMapEntry {
  private final String key;
  private final Pattern valuePattern;

  private ImmutableOsReleaseFileMapEntry(String key, Pattern valuePattern) {
    this.key = Objects.requireNonNull(key, "key");
    this.valuePattern = Objects.requireNonNull(valuePattern, "valuePattern");
  }

  private ImmutableOsReleaseFileMapEntry(ImmutableOsReleaseFileMapEntry original, String key, Pattern valuePattern) {
    this.key = key;
    this.valuePattern = valuePattern;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code valuePattern} attribute
   */
  @Override
  public Pattern valuePattern() {
    return valuePattern;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OsReleaseFileMapEntry#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOsReleaseFileMapEntry withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableOsReleaseFileMapEntry(this, newValue, this.valuePattern);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OsReleaseFileMapEntry#valuePattern() valuePattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valuePattern
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOsReleaseFileMapEntry withValuePattern(Pattern value) {
    if (this.valuePattern == value) return this;
    Pattern newValue = Objects.requireNonNull(value, "valuePattern");
    return new ImmutableOsReleaseFileMapEntry(this, this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOsReleaseFileMapEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOsReleaseFileMapEntry
        && equalTo(0, (ImmutableOsReleaseFileMapEntry) another);
  }

  private boolean equalTo(int synthetic, ImmutableOsReleaseFileMapEntry another) {
    return key.equals(another.key)
        && valuePattern.equals(another.valuePattern);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code valuePattern}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + valuePattern.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OsReleaseFileMapEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OsReleaseFileMapEntry{"
        + "key=" + key
        + ", valuePattern=" + valuePattern
        + "}";
  }

  /**
   * Construct a new immutable {@code OsReleaseFileMapEntry} instance.
   * @param key The value for the {@code key} attribute
   * @param valuePattern The value for the {@code valuePattern} attribute
   * @return An immutable OsReleaseFileMapEntry instance
   */
  public static ImmutableOsReleaseFileMapEntry of(String key, Pattern valuePattern) {
    return new ImmutableOsReleaseFileMapEntry(key, valuePattern);
  }

  /**
   * Creates an immutable copy of a {@link OsReleaseFileMapEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OsReleaseFileMapEntry instance
   */
  public static ImmutableOsReleaseFileMapEntry copyOf(OsReleaseFileMapEntry instance) {
    if (instance instanceof ImmutableOsReleaseFileMapEntry) {
      return (ImmutableOsReleaseFileMapEntry) instance;
    }
    return ImmutableOsReleaseFileMapEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOsReleaseFileMapEntry ImmutableOsReleaseFileMapEntry}.
   * <pre>
   * ImmutableOsReleaseFileMapEntry.builder()
   *    .key(String) // required {@link OsReleaseFileMapEntry#key() key}
   *    .valuePattern(regex.Pattern) // required {@link OsReleaseFileMapEntry#valuePattern() valuePattern}
   *    .build();
   * </pre>
   * @return A new ImmutableOsReleaseFileMapEntry builder
   */
  public static ImmutableOsReleaseFileMapEntry.Builder builder() {
    return new ImmutableOsReleaseFileMapEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOsReleaseFileMapEntry ImmutableOsReleaseFileMapEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OsReleaseFileMapEntry", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_VALUE_PATTERN = 0x2L;
    private long initBits = 0x3L;

    private String key;
    private Pattern valuePattern;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OsReleaseFileMapEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OsReleaseFileMapEntry instance) {
      Objects.requireNonNull(instance, "instance");
      this.key(instance.key());
      this.valuePattern(instance.valuePattern());
      return this;
    }

    /**
     * Initializes the value for the {@link OsReleaseFileMapEntry#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link OsReleaseFileMapEntry#valuePattern() valuePattern} attribute.
     * @param valuePattern The value for valuePattern 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder valuePattern(Pattern valuePattern) {
      this.valuePattern = Objects.requireNonNull(valuePattern, "valuePattern");
      initBits &= ~INIT_BIT_VALUE_PATTERN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOsReleaseFileMapEntry ImmutableOsReleaseFileMapEntry}.
     * @return An immutable instance of OsReleaseFileMapEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOsReleaseFileMapEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOsReleaseFileMapEntry(null, key, valuePattern);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE_PATTERN) != 0) attributes.add("valuePattern");
      return "Cannot build OsReleaseFileMapEntry, some of required attributes are not set " + attributes;
    }
  }
}
