package de.flapdoodle.os.common.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OsReleaseFile}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOsReleaseFile.builder()}.
 */
@Generated(from = "OsReleaseFile", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableOsReleaseFile implements OsReleaseFile {
  private final Map<String, String> attributes;

  private ImmutableOsReleaseFile(Map<String, String> attributes) {
    this.attributes = attributes;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @Override
  public Map<String, String> attributes() {
    return attributes;
  }

  /**
   * Copy the current immutable object by replacing the {@link OsReleaseFile#attributes() attributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the attributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOsReleaseFile withAttributes(Map<String, ? extends String> entries) {
    if (this.attributes == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableOsReleaseFile(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOsReleaseFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOsReleaseFile
        && equalTo(0, (ImmutableOsReleaseFile) another);
  }

  private boolean equalTo(int synthetic, ImmutableOsReleaseFile another) {
    return attributes.equals(another.attributes);
  }

  /**
   * Computes a hash code from attributes: {@code attributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + attributes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OsReleaseFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OsReleaseFile{"
        + "attributes=" + attributes
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OsReleaseFile} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OsReleaseFile instance
   */
  public static ImmutableOsReleaseFile copyOf(OsReleaseFile instance) {
    if (instance instanceof ImmutableOsReleaseFile) {
      return (ImmutableOsReleaseFile) instance;
    }
    return ImmutableOsReleaseFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOsReleaseFile ImmutableOsReleaseFile}.
   * <pre>
   * ImmutableOsReleaseFile.builder()
   *    .putAttributes|putAllAttributes(String =&gt; String) // {@link OsReleaseFile#attributes() attributes} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableOsReleaseFile builder
   */
  public static ImmutableOsReleaseFile.Builder builder() {
    return new ImmutableOsReleaseFile.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOsReleaseFile ImmutableOsReleaseFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OsReleaseFile", generator = "Immutables")
  public static final class Builder {
    private Map<String, String> attributes = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OsReleaseFile} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OsReleaseFile instance) {
      Objects.requireNonNull(instance, "instance");
      putAllAttributes(instance.attributes());
      return this;
    }

    /**
     * Put one entry to the {@link OsReleaseFile#attributes() attributes} map.
     * @param key The key in the attributes map
     * @param value The associated value in the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(String key, String value) {
      this.attributes.put(
          Objects.requireNonNull(key, "attributes key"),
          Objects.requireNonNull(value, value == null ? "attributes value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link OsReleaseFile#attributes() attributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.attributes.put(
          Objects.requireNonNull(k, "attributes key"),
          Objects.requireNonNull(v, v == null ? "attributes value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OsReleaseFile#attributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder attributes(Map<String, ? extends String> entries) {
      this.attributes.clear();
      return putAllAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OsReleaseFile#attributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAttributes(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.attributes.put(
            Objects.requireNonNull(k, "attributes key"),
            Objects.requireNonNull(v, v == null ? "attributes value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOsReleaseFile ImmutableOsReleaseFile}.
     * @return An immutable instance of OsReleaseFile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOsReleaseFile build() {
      return new ImmutableOsReleaseFile(createUnmodifiableMap(false, false, attributes));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
