/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.ImmutableTypeCheckPredicate;
import java.util.function.Predicate;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TypeCheckPredicate<T>
implements Predicate<T> {
    @Value.Parameter
    protected abstract Class<T> typeClass();

    @Value.Parameter
    protected abstract Predicate<T> check();

    @Override
    public boolean test(T t) {
        if (this.typeClass().isInstance(t)) {
            return this.check().test(t);
        }
        return false;
    }

    public static <T> TypeCheckPredicate<T> of(Class<T> type, Predicate<T> check) {
        return ImmutableTypeCheckPredicate.of(type, check);
    }

    public static <T> TypeCheckPredicate<T> isInstanceOf(Class<T> type) {
        return TypeCheckPredicate.of(type, it -> true);
    }
}

