/*
 * Copyright (C) 2020
 *   Michael Mosmann <michael@mosmann.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.common.types.OsReleaseFile;

import java.util.List;

public enum UbuntuVersion implements Version {
  UBUNTU_18_04(osReleaseFileVersionMatches("18.04")),
  UBUNTU_18_10(osReleaseFileVersionMatches("18.10")),
  UBUNTU_19_04(osReleaseFileVersionMatches("19.04")),
  UBUNTU_19_10(osReleaseFileVersionMatches("10.10")),
  UBUNTU_20_04(osReleaseFileVersionMatches("20.04")),
  UBUNTU_20_10(osReleaseFileVersionMatches("20.10"));

  private final List<Peculiarity<?>> peculiarities;

  <T extends Enum<T> & Architecture> UbuntuVersion(Peculiarity... peculiarities) {
    this.peculiarities  = HasPecularities.asList(peculiarities);
  }

  @Override
  public List<Peculiarity<?>> pecularities() {
    return peculiarities;
  }

  private static Peculiarity<OsReleaseFile> osReleaseFileVersionMatches(String version) {
    return Peculiarity.of(LinuxDistribution.osReleaseFile(), Matchers.osReleaseFileEntry("VERSION_ID", ".*" + version + ".*"));
  }

}
