package de.flapdoodle.os.common.attributes;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MappedTextFile}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMappedTextFile.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableMappedTextFile.of()}.
 */
@Generated(from = "MappedTextFile", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMappedTextFile<T> implements MappedTextFile<T> {
  private final String name;
  private final Function<String, T> converter;
  private final Charset charset;

  private ImmutableMappedTextFile(String name, Function<String, T> converter) {
    this.name = Objects.requireNonNull(name, "name");
    this.converter = Objects.requireNonNull(converter, "converter");
    this.charset = Objects.requireNonNull(MappedTextFile.super.charset(), "charset");
  }

  private ImmutableMappedTextFile(ImmutableMappedTextFile.Builder<T> builder) {
    this.name = builder.name;
    this.converter = builder.converter;
    this.charset = builder.charset != null
        ? builder.charset
        : Objects.requireNonNull(MappedTextFile.super.charset(), "charset");
  }

  private ImmutableMappedTextFile(
      String name,
      Function<String, T> converter,
      Charset charset) {
    this.name = name;
    this.converter = converter;
    this.charset = charset;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code converter} attribute
   */
  @Override
  public Function<String, T> converter() {
    return converter;
  }

  /**
   * @return The value of the {@code charset} attribute
   */
  @Override
  public Charset charset() {
    return charset;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MappedTextFile#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedTextFile<T> withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableMappedTextFile<>(newValue, this.converter, this.charset);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MappedTextFile#converter() converter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for converter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedTextFile<T> withConverter(Function<String, T> value) {
    if (this.converter == value) return this;
    Function<String, T> newValue = Objects.requireNonNull(value, "converter");
    return new ImmutableMappedTextFile<>(this.name, newValue, this.charset);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MappedTextFile#charset() charset} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for charset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMappedTextFile<T> withCharset(Charset value) {
    if (this.charset == value) return this;
    Charset newValue = Objects.requireNonNull(value, "charset");
    return new ImmutableMappedTextFile<>(this.name, this.converter, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMappedTextFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMappedTextFile<?>
        && equalTo((ImmutableMappedTextFile<?>) another);
  }

  private boolean equalTo(ImmutableMappedTextFile<?> another) {
    return name.equals(another.name)
        && converter.equals(another.converter)
        && charset.equals(another.charset);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code converter}, {@code charset}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + converter.hashCode();
    h += (h << 5) + charset.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MappedTextFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MappedTextFile{"
        + "name=" + name
        + ", converter=" + converter
        + ", charset=" + charset
        + "}";
  }

  /**
   * Construct a new immutable {@code MappedTextFile} instance.
 * @param <T> generic parameter T
   * @param name The value for the {@code name} attribute
   * @param converter The value for the {@code converter} attribute
   * @return An immutable MappedTextFile instance
   */
  public static <T> ImmutableMappedTextFile<T> of(String name, Function<String, T> converter) {
    return new ImmutableMappedTextFile<>(name, converter);
  }

  /**
   * Creates an immutable copy of a {@link MappedTextFile} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable MappedTextFile instance
   */
  public static <T> ImmutableMappedTextFile<T> copyOf(MappedTextFile<T> instance) {
    if (instance instanceof ImmutableMappedTextFile<?>) {
      return (ImmutableMappedTextFile<T>) instance;
    }
    return ImmutableMappedTextFile.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMappedTextFile ImmutableMappedTextFile}.
   * <pre>
   * ImmutableMappedTextFile.&amp;lt;T&amp;gt;builder()
   *    .name(String) // required {@link MappedTextFile#name() name}
   *    .converter(function.Function&amp;lt;String, T&amp;gt;) // required {@link MappedTextFile#converter() converter}
   *    .charset(java.nio.charset.Charset) // optional {@link MappedTextFile#charset() charset}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableMappedTextFile builder
   */
  public static <T> ImmutableMappedTextFile.Builder<T> builder() {
    return new ImmutableMappedTextFile.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMappedTextFile ImmutableMappedTextFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MappedTextFile", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CONVERTER = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Function<String, T> converter;
    private Charset charset;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MappedTextFile} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(MappedTextFile<T> instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      converter(instance.converter());
      charset(instance.charset());
      return this;
    }

    /**
     * Initializes the value for the {@link MappedTextFile#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MappedTextFile#converter() converter} attribute.
     * @param converter The value for converter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> converter(Function<String, T> converter) {
      this.converter = Objects.requireNonNull(converter, "converter");
      initBits &= ~INIT_BIT_CONVERTER;
      return this;
    }

    /**
     * Initializes the value for the {@link MappedTextFile#charset() charset} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MappedTextFile#charset() charset}.</em>
     * @param charset The value for charset 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> charset(Charset charset) {
      this.charset = Objects.requireNonNull(charset, "charset");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMappedTextFile ImmutableMappedTextFile}.
     * @return An immutable instance of MappedTextFile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMappedTextFile<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMappedTextFile<T>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CONVERTER) != 0) attributes.add("converter");
      return "Cannot build MappedTextFile, some of required attributes are not set " + attributes;
    }
  }
}
