/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="Platform", generator="Immutables")
public final class ImmutablePlatform
extends Platform {
    private final OS operatingSystem;
    private final Architecture architecture;
    private final Distribution distribution;
    private final Version version;

    private ImmutablePlatform(OS operatingSystem, Architecture architecture, Distribution distribution, Version version) {
        this.operatingSystem = operatingSystem;
        this.architecture = architecture;
        this.distribution = distribution;
        this.version = version;
    }

    @Override
    public OS operatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public Architecture architecture() {
        return this.architecture;
    }

    @Override
    public Optional<Distribution> distribution() {
        return Optional.ofNullable(this.distribution);
    }

    @Override
    public Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    public final ImmutablePlatform withOperatingSystem(OS value) {
        if (this.operatingSystem == value) {
            return this;
        }
        OS newValue = Objects.requireNonNull(value, "operatingSystem");
        if (this.operatingSystem.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(newValue, this.architecture, this.distribution, this.version);
    }

    public final ImmutablePlatform withArchitecture(Architecture value) {
        if (this.architecture == value) {
            return this;
        }
        Architecture newValue = Objects.requireNonNull(value, "architecture");
        return new ImmutablePlatform(this.operatingSystem, newValue, this.distribution, this.version);
    }

    public final ImmutablePlatform withDistribution(Distribution value) {
        Distribution newValue = Objects.requireNonNull(value, "distribution");
        if (this.distribution == newValue) {
            return this;
        }
        return new ImmutablePlatform(this.operatingSystem, this.architecture, newValue, this.version);
    }

    public final ImmutablePlatform withDistribution(Optional<? extends Distribution> optional) {
        Distribution value = optional.orElse(null);
        if (this.distribution == value) {
            return this;
        }
        return new ImmutablePlatform(this.operatingSystem, this.architecture, value, this.version);
    }

    public final ImmutablePlatform withVersion(Version value) {
        Version newValue = Objects.requireNonNull(value, "version");
        if (this.version == newValue) {
            return this;
        }
        return new ImmutablePlatform(this.operatingSystem, this.architecture, this.distribution, newValue);
    }

    public final ImmutablePlatform withVersion(Optional<? extends Version> optional) {
        Version value = optional.orElse(null);
        if (this.version == value) {
            return this;
        }
        return new ImmutablePlatform(this.operatingSystem, this.architecture, this.distribution, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatform && this.equalTo((ImmutablePlatform)another);
    }

    private boolean equalTo(ImmutablePlatform another) {
        return this.operatingSystem.equals(another.operatingSystem) && this.architecture.equals(another.architecture) && Objects.equals(this.distribution, another.distribution) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operatingSystem.hashCode();
        h += (h << 5) + this.architecture.hashCode();
        h += (h << 5) + Objects.hashCode(this.distribution);
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Platform{");
        builder.append("operatingSystem=").append(this.operatingSystem);
        builder.append(", ");
        builder.append("architecture=").append(this.architecture);
        if (this.distribution != null) {
            builder.append(", ");
            builder.append("distribution=").append(this.distribution);
        }
        if (this.version != null) {
            builder.append(", ");
            builder.append("version=").append(this.version);
        }
        return builder.append("}").toString();
    }

    public static ImmutablePlatform copyOf(Platform instance) {
        if (instance instanceof ImmutablePlatform) {
            return (ImmutablePlatform)instance;
        }
        return ImmutablePlatform.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Platform", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_OPERATING_SYSTEM = 1L;
        private static final long INIT_BIT_ARCHITECTURE = 2L;
        private long initBits = 3L;
        private OS operatingSystem;
        private Architecture architecture;
        private Distribution distribution;
        private Version version;

        private Builder() {
        }

        public final Builder from(Platform instance) {
            Optional<Version> versionOptional;
            Objects.requireNonNull(instance, "instance");
            this.operatingSystem(instance.operatingSystem());
            this.architecture(instance.architecture());
            Optional<Distribution> distributionOptional = instance.distribution();
            if (distributionOptional.isPresent()) {
                this.distribution(distributionOptional);
            }
            if ((versionOptional = instance.version()).isPresent()) {
                this.version(versionOptional);
            }
            return this;
        }

        public final Builder operatingSystem(OS operatingSystem) {
            this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder architecture(Architecture architecture) {
            this.architecture = Objects.requireNonNull(architecture, "architecture");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder distribution(Distribution distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            return this;
        }

        public final Builder distribution(Optional<? extends Distribution> distribution) {
            this.distribution = distribution.orElse(null);
            return this;
        }

        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public final Builder version(Optional<? extends Version> version) {
            this.version = version.orElse(null);
            return this;
        }

        public ImmutablePlatform build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlatform(this.operatingSystem, this.architecture, this.distribution, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operatingSystem");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("architecture");
            }
            return "Cannot build Platform, some of required attributes are not set " + attributes;
        }
    }
}

