/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.common.types.OsReleaseFile;
import de.flapdoodle.os.common.types.OsReleaseFileConverter;
import java.util.regex.Pattern;

public class OsReleaseFiles {
    public static String RELEASE_FILE_NAME = "/etc/os-release";
    public static String NAME = "NAME";
    public static String VERSION_ID = "VERSION_ID";
    public static String VERSION_CODENAME = "VERSION_CODENAME";

    static Attribute<OsReleaseFile> osReleaseFile() {
        return OsReleaseFiles.releaseFile(RELEASE_FILE_NAME);
    }

    static Attribute<OsReleaseFile> releaseFile(String path) {
        return Attributes.mappedTextFile(path, OsReleaseFileConverter.INSTANCE);
    }

    static DistinctPeculiarity<OsReleaseFile> nameMatches(Attribute<OsReleaseFile> osReleaseFile, String name) {
        return DistinctPeculiarity.of(osReleaseFile, Matchers.osReleaseFileEntry(NAME, ".*" + name + ".*"));
    }

    static DistinctPeculiarity<OsReleaseFile> versionMatches(Attribute<OsReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, Matchers.osReleaseFileEntry(VERSION_ID, Pattern.quote(version) + ".*"));
    }

    static DistinctPeculiarity<OsReleaseFile> versionIs(Attribute<OsReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, Matchers.osReleaseFileEntry(VERSION_ID, Pattern.quote(version)));
    }

    static DistinctPeculiarity<OsReleaseFile> versionCodeNameIs(Attribute<OsReleaseFile> osReleaseFile, String version) {
        return DistinctPeculiarity.of(osReleaseFile, Matchers.osReleaseFileEntry(VERSION_CODENAME, Pattern.quote(version)));
    }

    static DistinctPeculiarity<OsReleaseFile> osReleaseFileNameMatches(String name) {
        return OsReleaseFiles.nameMatches(OsReleaseFiles.osReleaseFile(), name);
    }

    static DistinctPeculiarity<OsReleaseFile> osReleaseFileVersionMatches(String version) {
        return OsReleaseFiles.versionMatches(OsReleaseFiles.osReleaseFile(), version);
    }

    static DistinctPeculiarity<OsReleaseFile> osReleaseFileVersionIs(String version) {
        return OsReleaseFiles.versionIs(OsReleaseFiles.osReleaseFile(), version);
    }

    static DistinctPeculiarity<OsReleaseFile> osReleaseFileVersionCodeNameIs(String version) {
        return OsReleaseFiles.versionCodeNameIs(OsReleaseFiles.osReleaseFile(), version);
    }
}

